/*
 * testprog3.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \file testprog3.c
 *  \author Fernando Pujaico Rivera
 *  \date 01-01-2020
 *  \brief Programa para el testeo de algunas funciones de la biblioteca.
 *  
 *  \n\n Este programa solo hace una prueba simple de las funciones que hice
 *  mas al tun tun.
 */


#include <stdlib.h>
#include <math.h>
#include <pds/pdsra.h>
#include <pds/pdsrv.h>
#include <pds/pdsnn.h>

#include "octplot.h"
#include "data_work.h"

int pds_vector_init_func(PdsVector *V,PdsUniform *RV,float (*func)(float));
float funcion(float n);

int main(int argc, char** argv)
{
	PdsNeuronML *MLayer=NULL;
	PdsVector *X=NULL;
	PdsVector *Y=NULL;
	PdsUniform *RV=NULL;

	PdsNnNatural i,id,itera,iterb;
    PdsNnNatural Ntraining=128;
    PdsNnNatural Ntests=4;
	PdsNnNatural MaxIter;
	PdsNnReal Error;
	PdsNnReal Alpha;

	// Creo una Random Variable
	RV=pds_uniform_new(-1,1);

	// Creo el vector que indicará la cantidad de electrones por capa.
	// 5 Capas.
    PdsNnNatural Larray[]={32,64,42,28,14,7};

	// Creo El vector de entrada X.
	X=pds_vector_new(Larray[0]);
	// Creo El vector de entrada Y.
	Y=pds_vector_new(Larray[5]);

	////////////////////////////////////////////////////////////////////////

	MLayer=pds_neuronml_new_from_array(Larray,6);
	pds_neuronml_init_weight_uniform(MLayer,RV);
	pds_neuronml_init_u_uniform(MLayer,RV);
	Alpha=0.6;      pds_neuronml_set_alpha(MLayer,Alpha);
	Error=0.1;      pds_neuronml_set_max_error(MLayer,Error);
	MaxIter=8192;   pds_neuronml_set_max_iterations(MLayer,MaxIter);

	// Entrenando
    id=0;
	for(i=0;id<Ntraining;i++)
	{
		printf("\nEntrenamiento %4d: id=%4d\n",i,id);

		// Entrenando de forma negativa.
        function_data_work_init_data0(X,Y);
		pds_neuronml_training(MLayer,X,Y);
		itera=pds_neuronml_training_results_printf(MLayer,"-1");

		// Entrenando de forma positiva.
        function_data_work_init_data1(X,Y);
		pds_neuronml_training(MLayer,X,Y);
		iterb=pds_neuronml_training_results_printf(MLayer,"+1");
		
        if( (itera==0)&&(iterb==0) )    id++;
        else                            id=0;

	}

	printf("\n\n");
	// Iterando
	for(i=0;i<Ntests;i++)
	{
        function_data_work_init_data1(X,Y);
		pds_neuronml_iterate(MLayer,X,Y);
		pds_neuronml_iterate_results_printf(MLayer,"+1");
    	function_octplot_vector_in_png(X,"n","X[n]","octfilegood.m","xgood.png");
	}


	printf("\n");
	for(i=0;i<Ntests;i++)
	{
        function_data_work_init_data0(X,Y);
		pds_neuronml_iterate(MLayer,X,Y);
		pds_neuronml_iterate_results_printf(MLayer,"-1");
    	function_octplot_vector_in_png(X,"n","X[n]","octfilebad.m","xbad.png");
	}
    
	pds_neuronml_free(MLayer);

	printf("\n");

	pds_vector_free(X);
	pds_vector_free(Y);

	return EXIT_SUCCESS;
}

