/*
 * example_load_training_save_test.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \example example_load_training_save_test.c
 *  \author Fernando Pujaico Rivera
 *  \date 01-01-2012
 *  \brief Programa para el testeo de algunas funciones de la biblioteca.
 *  
 *  \n\n Este programa solo hace una prueba simple de las funciones que hice
 *  mas al tun tun.
 */

// ./test/example_load_training_save_test ../test/data.mlayer
#include <stdlib.h>
#include <math.h>

#include <pds/pdsra.h>
#include <pds/pdsnn.h>
    
#include "octplot.h"
    
int main(int argc, char** argv)
{
    PdsNeuronML *MLayer=NULL;

    PdsNnNatural i,id=0,itera,iterb;
    PdsNnNatural Ntraining=100;
    PdsNnNatural Ntests=4;

    PdsNnNatural Nin;
    PdsNnNatural Nout;
    
    if(argc==1)         return EXIT_FAILURE;
    
    /******************** Cargando la red neuronal ********************/
    
    MLayer=pds_neuronml_new_load_data(argv[1]);
    if(MLayer==NULL)    return EXIT_FAILURE;
    pds_neuronml_head_printf(MLayer);
    
    pds_neuronml_get_number_of_input_neurons(MLayer,&Nin);
    pds_neuronml_get_number_of_output_neurons(MLayer,&Nout);
    
    // Creo el vector de entrada X.
    PdsVector *X=pds_vector_new(Nin);
    // Creo el vector de entrada Y.
    PdsVector *Y=pds_vector_new(Nout);
    
    /******************** Treinando la red neuronal ********************/
    
    for(i=0;id<Ntraining;i++)
    {
        printf("\nEntrenando %d: id %d\n",i,id);
        
        // Entrenando de forma negativa.
        pds_generate_data_input_rand(X,1.0);
        pds_generate_data_output_negative(Y);   // Loading randomly a negative data vectors {X,Y}
        
        pds_neuronml_training(MLayer,X,Y);
        itera=pds_neuronml_training_results_printf(MLayer,"-1");
        
        // Entrenando de forma positiva.
        pds_generate_data_input_func2pi(X,sin,6,0.05);
        pds_generate_data_output_positive(Y);   // Loading randomly a positive data vectors {X,Y}
        
        pds_neuronml_training(MLayer,X,Y);
        iterb=pds_neuronml_training_results_printf(MLayer,"+1");
        
        if( (itera==0)&&(iterb==0) )    id++;
        else                            id=0;
    }
    
    /******************** Salvando la red neuronal ********************/
    
    pds_neuronml_save_data(MLayer,argv[1]);
    printf("\n\n");
    
    /******************** Testando la red neuronal ********************/
    
    char filename[128];
    
    // Testando de forma negativa.
    for(i=0;i<Ntests;i++)
    {
        pds_generate_data_input_rand(X,1.0);
        pds_neuronml_iterate(MLayer,X,Y);
        pds_neuronml_iterate_results_printf(MLayer,"-1");
        
        sprintf(filename,"xbad%d.png",i);
        function_octplot_vector_in_png(X,"n","X[n]","octfilebad.m",filename);
    }
    
    printf("\n");
    
    // Testando de forma positiva.
    for(i=0;i<Ntests;i++)
    {
        pds_generate_data_input_func2pi(X,sin,6,0.05);
        pds_neuronml_iterate(MLayer,X,Y);
        pds_neuronml_iterate_results_printf(MLayer,"+1");
        
        sprintf(filename,"xgood%d.png",i);
        function_octplot_vector_in_png(X,"n","X[n]","octfilegood.m",filename);
    }
    
    /******************************************************************/
    
    pds_neuronml_free(MLayer);
    pds_vector_free(X);
    pds_vector_free(Y);

    return EXIT_SUCCESS;
}





