/*
 * example_load_test.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \example example_load_test.c
 *  \author Fernando Pujaico Rivera
 *  \date 01-01-2020
 *  \brief Programa para el testeo de algunas funciones de la biblioteca.
 *  
 *  \n\n Este programa solo hace una prueba simple de las funciones que hice
 *  mas al tun tun.
 */
    
#include <stdlib.h>
#include <math.h>
    
#include <pds/pdsra.h>
#include <pds/pdsnn.h>
        
// ./test/example_load_test ../test/data.mlayer
int main(int argc, char** argv)
{
    PdsNnNatural i;
    PdsNnNatural Ntests=4;
    PdsNnNatural Nin,Nout;
    
    if(argc==1)         return EXIT_FAILURE;
    
    // Loading the neural network from filepath in argv[1].
    PdsNeuronML *MLayer=pds_neuronml_new_load_data(argv[1]);
    if(MLayer==NULL)    return EXIT_FAILURE;
    
    // Console print of head data in neural network.
    pds_neuronml_head_printf(MLayer);
    printf("\n");
    
    // Creating temporal vectors X and Y.
    pds_neuronml_get_number_of_input_neurons(MLayer,&Nin);
    pds_neuronml_get_number_of_output_neurons(MLayer,&Nout);
    PdsVector *X = pds_vector_new(Nin);
    PdsVector *Y = pds_vector_new(Nout);
    if( (X==NULL)||(Y==NULL) )  return EXIT_FAILURE;
        
    // Testing negative values.
    for(i=0;i<Ntests;i++)
    {
        pds_generate_data_input_rand(X,1.0); // Loading randomly a negative data vector X
        
        pds_neuronml_iterate(MLayer,X,Y);
        pds_neuronml_iterate_results_printf(MLayer,"-1");
    }
    
    printf("\n");
    
    // Testing positive values.
    for(i=0;i<Ntests;i++)
    {
        pds_generate_data_input_func2pi(X,sin,6,0.05); // Loading randomly a positive data vector X
        
        pds_neuronml_iterate(MLayer,X,Y);
        pds_neuronml_iterate_results_printf(MLayer,"+1");
    }
    
    printf("\n");
        
    pds_vector_free(X);
    pds_vector_free(Y);
    pds_neuronml_free(MLayer);
        
    return EXIT_SUCCESS;
}

