/*
 * testprog3.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \example testprog3.c
 *  \author Fernando Pujaico Rivera
 *  \date 01-01-2012
 *  \brief Programa para el testeo de algunas funciones de la biblioteca.
 *  
 *  \n\n Este programa solo hace una prueba simple de las funciones que hice
 *  mas al tun tun.
 */

#include <config.h>
#include <stdlib.h>
#include <math.h>
#include <pds/pdsra.h>
#include <pds/pdsrv.h>
#include <pds/pdsnn.h>
#include "extras.h"

int pds_vector_init_func(PdsVector *V,PdsUniform *RV,float (*func)(float));
float funcion(float n);

int main(int argc, char** argv)
{
	PdsNeuronML *MLayer=NULL;
	PdsVector *X=NULL;
	PdsVector *Y=NULL;
	PdsUniform *Xrv=NULL;
	PdsNnReal m;

	PdsNnNatural i,id,N;
	PdsNnNatural IterN,IterP;

	FILE *fd=NULL;

	// Creo una Random Variable de entrada
	Xrv=pds_uniform_new(-128,128);

	MLayer=pds_neuronml_new_load_data("data.mlayer");
	if(MLayer==NULL)	EXIT_FAILURE;

	// Creo El vector de entrada X.
	X=pds_vector_new(MLayer->L[0]);
	// Creo El vector de entrada Y.
	Y=pds_vector_new(MLayer->L[MLayer->N]);

	N=9;

	// Entrenando
	id=0;
	for(i=0;id<N;i++)
	{
		printf("\nEntrenando %d\n",i);

		// Entrenando de forma negativa.
		pds_uniform_get_vector(Xrv,X);
		pds_vector_init_value(Y,-1.0);
		pds_neuronml_training(MLayer,X,Y);
		pds_neuronml_get_number_iterations(MLayer,&IterN);
		printf("%6d<<Negativo>>\n",IterN);
		//printf("Y=\t");	pds_vector_printf(Y);

		// Entrenando de forma positiva.
		pds_vector_init_func(X,Xrv,funcion);
		pds_vector_init_value(Y,1.0);
		pds_neuronml_training(MLayer,X,Y);
		pds_neuronml_get_number_iterations(MLayer,&IterP);
		printf("%6d<<Positivo>>\n",IterP);
		//printf("Y=\t");	pds_vector_printf(Y);
		
		if((IterN==0)&&(IterP==0))	id++;
		else				        id=0;
	}

	pds_neuronml_save_data(MLayer,"data.mlayer");
	printf("\n\n");

	// Iterando
	for(i=0;i<N;i++)
	{
		pds_vector_init_func(X,Xrv,funcion);
		pds_neuronml_iterate(MLayer,X,Y);
		pds_neuronml_get_soft_vote(MLayer,&m);
		printf("H:%5.2f <<Positivo>>\n",m);
		//printf("Y=\t");	pds_vector_printf(Y);
		//if(m< 0)	break;
	}
	pds_octplot_vector_in_png(X,"n","X[n]","octfilegood.m","xgood.png");

	printf("\n");
	for(i=0;i<N;i++)
	{
		pds_uniform_get_vector(Xrv,X);
		pds_neuronml_iterate(MLayer,X,Y);
		pds_neuronml_get_soft_vote(MLayer,&m);
		printf("H:%5.2f <<Negativo>>\n",m);
		//printf("Y=\t");	pds_vector_printf(Y);
		//if(m>=0)	break;
	}
	pds_octplot_vector_in_png(X,"n","X[n]","octfilebad.m","xbad.png");


	pds_neuronml_free(MLayer);

	printf("\n");

	pds_vector_free(X);
	pds_vector_free(Y);
	pds_uniform_free(Xrv);

	return EXIT_SUCCESS;
}

int pds_vector_init_func(PdsVector *V,PdsUniform *RV,float (*func)(float))
{
	PdsRaNatural i;
	PdsRvReal m,phase;

	if(V==NULL)	return FALSE;

	pds_uniform_get_value(RV,&phase);
	for(i=0;i<V->Nel;i++)	
	{
		pds_uniform_get_value(RV,&m);
		V->V[i]=func(i+phase*M_PI/128.0)+0.25*m;
	}

	return TRUE;
}

float funcion(float n)
{
	float F0=50;
	float Fs=512;
	float e,y;

	y=128*sin(2*M_PI*F0*n/Fs);

	return y+e;
}
