/*
 * pdsftglobal.h
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \file pdsftglobal.h
 *  \brief Archivo de definición de cabeceras
 *
 *  \author Fernando Pujaico Rivera
 */
#ifndef __PDSFTGLOBAL_H__
#define __PDSFTGLOBAL_H__

#ifdef __cplusplus
extern "C" {
#endif 

/** \defgroup PdsFtGlobalGroup Definiciones globales.
 *  \brief Definiciones globales en toda la biblioteca pdsft.
 *
 *  Aqui podras habilitar o deshabilitar los modulos que no quieras usar
 * @{
 */

/*! Se define una variable como real.
 *  \ingroup PdsFtGlobalGroup
 */
typedef float PdsFtReal;

/*! Se define una variable como un número natural incluyendo el cero.
 *  \ingroup PdsFtGlobalGroup
 */
typedef unsigned int PdsFtNatural;

/**
 * @}
 */

#ifdef __cplusplus
}
#endif 

#endif /* __PDSFTGLOBAL_H__ */

