/**
   \mainpage PDS Digital Filters
   <br>
   \author Fernando Pujaico Rivera
   \date 30 de Agosto del 2015


	\tableofcontents

	\section Download Descarga
    La última versión de la biblioteca PDS Digital Filters (libpdsdf) puede ser descargada de este 
    <a href="http://download.savannah.gnu.org/releases/pdsplibrary/src/libpdsdf/">enlace</a>

	\section desc_sec Descripción
   Aqui encontraras un conjunto de funciones para filtrar señales digitales.

	\section comp_subsec Compilando e instalando la biblioteca PDS Digital Filters
	Para compilar la biblioteca <b>PDS Digital Filters</b> es necesario tener en cuenta
	el siguiente diagrama de dependencias de bibliotecas. 
	<center>
	\image html compilar.png "Crear/Compilar la biblioteca PDS Digital Filters."
	</center>
	Como se puede ver, son necesarios los archivos de definiciones `*.h`  y 
	las bibliotecas empaquetadas en binario (`*.a` o `*.so`).
	Para instalar la biblioteca solo es necesario:<br>
\code{.h}
	# Define donde se instalará la biblioteca, ejemplo: /usr
	./configure	--prefix=/usr
	# Compilar e instalar la biblioteca
	make
	sudo make install
\endcode

	\section link_subsec Usando la biblioteca para compilar un programa
	Una vez instalada la biblioteca <b>PDS Digital Filters</b>, para que esta pueda
	ser	usada por algún otro proyecto, es necesario tener en cuenta el
	siguiente diagrama de dependencia de la biblioteca. 
	<center>
	\image html enlazar.png "Usar/Enlazar la biblioteca PDS Digital Filters."
	</center>
	Para usar <b>PDS Digital Filters</b> en un proyecto (como test.c), 
	se debe agregar la siguiente cabecera al inicio del código fuente.
\code{.h}
	#include <pds/pdsdf.h>
\endcode
	Esto incluirá todas las definiciones de las funciones de la biblioteca
    PDS Digital Filters.

    \subsection Compilando Compilando un ejemplo
	Luego para compilar <b>enlazando estaticamente</b> (Statically linked) un archivo 
    de código fuente llamado test.c, debe ser usado el siguiente comando
\code{.h}
	gcc -static -o test test.c -lpdsdf
\endcode
    Por otro lado si se desea compilar <b>enlazando dinamicamente</b> (Dynamically linked) un archivo 
    de código fuente llamado test.c, debe ser usado el siguiente comando
\code{.h}
	gcc -o test test.c -lpdsdf
\endcode

    \subsection CompilandoPkgConfig Compilando un ejemplo - usando pkg-config
    Adicionalmente es posible usar pkg-config para obtener los datos de 
    configuración del proceso de compilación.
    \warning Es necesario tener instalado pkg-config

\code{.h}
 #Statically linked.

	gcc -static -o test test.c `pkg-config --libs  --cflags libpdsdf`
\endcode
<br>
\code{.h}
 #Dynamically linked.

	gcc -o test test.c `pkg-config --libs  --cflags libpdsdf`
\endcode
    
    \section Version Versión
    Es posible conocer la version instalada de la biblioteca libpdsdf usando
    el siguiente comando<br>
\code{.h}
    pkg-config --modversion libpdsdf
\endcode

*/

