/*
 * testprog1.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */


/** \file testprog2.c
 *  \author Fernando Pujaico Rivera
 *  \date 07-05-2011
 *  \brief Programa para el testeo de la biblioteca PDSBA.
 *  
 */

#include <config.h>
#include <stdlib.h>
#include <pds/pdsba.h>

void init_matriz(PdsBMatrix *M1)
{
	PdsBaNatural i,j,k;

	for(i=0,k=0;i<M1->Nlin;i++)
	for(j=0    ;j<M1->Ncol;j++,k++)
	{
		if( ((k%3)==0)||((k%5)==0) )	pds_bmatrix_set_bit(M1,i,j,1);
		else				pds_bmatrix_set_bit(M1,i,j,0);
	}
}

int main(int argc, char** argv)
{
	///////////////////////////////////////////////////////////////
	PdsBMatrix *M1=NULL;
	PdsBVector *V2=NULL;
	PdsBaNatural m;
	PdsBaByte B;
	PdsBaBit b;
	PdsBMatrix *M2=NULL;

	//creo e inicializo la matriz
	M1=pds_bmatrix_new(4,10);
	init_matriz(M1);			pds_bmatrix_printf(M1);
	
	//Cuento unos por fila y columna
	pds_bmatrix_row_weight(M1,0,&m);	printf("\nfila 0:\tpeso=%d\n",m);
	pds_bmatrix_column_weight(M1,0,&m);	printf("colu 0:\tpeso=%d\n\n",m);

	//Creo un archivo en formato alist
	pds_bmatrix_alist_save(M1,"Archivo.alist");

	//Creo una nueva matriz sistemática
	printf("Sistematica:\n");
	M2=pds_bmatrix_systematize(M1,&m);		pds_bmatrix_printf(M2);


	return EXIT_SUCCESS;
}
