// This file is part of the pdr/pdx project.
// Copyright (C) 2010 Torsten Mueller, Bern, Switzerland
//
// This program is free software: you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation, either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#include "../libpdrx/common.h"

using namespace std;
using namespace boost;
using namespace boost::posix_time;
using namespace boost::gregorian;
using namespace boost::program_options;

#include "../libpdrx/datatypes.h"
#include "../libpdrx/config.h"
#include "db.h"
#include "out_impl.h"

//=== Output (abstract base class) =========================================
Output::~Output ()
{
}

//=== OutputFactory ========================================================
OutputFactory::OutputFactory ()
	: m_outputs()
	, m_initialized(false)
{
}

OutputFactory::~OutputFactory ()
{
	foreach (Output* pOutput, m_outputs)
	{
		delete pOutput;
	}
}

const OutputFactory::Outputs& OutputFactory::GetOutputs (const Config& config) throw (Xception)
{
	if (!m_initialized)
	{
		m_initialized = true;

		const string& filename = config.GetFilenameOption("export");
		if (!filename.empty())
			m_outputs.push_back(new OutputXML("", filename));

		// ...
	}

	return m_outputs;
}
