// This file is part of the pdr/pdx project.
// Copyright (C) 2010 Torsten Mueller, Bern, Switzerland
//
// This program is free software: you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation, either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef __OUT_IMPL_H
#define __OUT_IMPL_H

#include "out.h"

class FTree;
class Database;

//=== OutputImpl (abstract base class) =====================================
class OutputImpl: public Output {

	protected:

	string	m_option_key;

		OutputImpl (const string& option_key);

	virtual string GetVerboseName () const;

	static FTree* Parse (const string& input) throw (Xception);
};

//=== OutputInteractive ====================================================
class OutputInteractive: public OutputImpl {

	public:

		OutputInteractive (const string& option_key);

	virtual	void Do (const Config& config, const Database& database) const throw (Xception);
};

//=== OutputReport =========================================================
class OutputReport: public OutputImpl {

	public:

		OutputReport (const string& option_key);

	virtual	void Do (const Config& config, const Database& database) const throw (Xception);
};

//=== OutputDiagram ========================================================
class OutputDiagram: public OutputImpl {

	public:

		OutputDiagram (const string& option_key);

	virtual	void Do (const Config& config, const Database& database) const throw (Xception);
};

#endif
