// This file is part of the pdr/pdx project.
// Copyright (C) 2010 Torsten Mueller, Bern, Switzerland
//
// This program is free software: you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation, either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef __POCO_DB_H
#define __POCO_DB_H

namespace Poco {
	namespace Data {
		class Connector;
		class Session;
	}
}

//=== PocoDatabase =========================================================
//
// This class is the abstract base class of all database classes that are
// using concrete POCO classes. It unifies the session handling and the
// access on collection meta informations which is absolutely common to
// both pdr and pdx.
//
class PocoDatabase {

	protected:

	struct CollectionMetaInfo {
		string	m_collection;
		char	m_type;
		string	m_tblname;
	};

	struct less_cmi: public binary_function<const CollectionMetaInfo&, const CollectionMetaInfo&, bool> {
		result_type operator () (first_argument_type a, second_argument_type b) const
		{
			return a.m_collection < b.m_collection;
		}
	};

	typedef set<CollectionMetaInfo, less_cmi> CollectionMetaInfos;

	string			m_connect;
	bool			m_verbose;
	string			m_KEY;
	Poco::Data::Session*	m_pSession;
	CollectionMetaInfos	m_collectionMetaInfos;

		PocoDatabase (const string& connect, bool verbose, const string& KEY, Poco::Data::Connector* pConnector);
	virtual	~PocoDatabase ();

		void Connect () throw (Xception);
		const CollectionMetaInfo& GetCollectionMetaInfo (const string& name) const throw (Xception);
		char GetCollectionType (const string& name) const throw (Xception);

	virtual	void NoSchemaCallback () throw (Xception) =0;
};

//=== DBTransactor =========================================================
class DBTransactor {

	Poco::Data::Session*	m_pSession;

	public:

		DBTransactor (Poco::Data::Session* pSession);
	virtual ~DBTransactor ();

	virtual void Commit ();
};

#endif
