// This file is part of the pdr/pdx project.
// Copyright (C) 2010 Torsten Mueller, Bern, Switzerland
//
// This program is free software: you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation, either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef __DATATYPES_H
#define __DATATYPES_H

//=== Xception =============================================================
class Xception {

	protected:

	string		m_message;

	public:

		Xception (const string& message);
		Xception (const format& message);
	virtual	~Xception ();

	const string&	Message () const;
};

//=== Xarning ==============================================================
class Xarning: public Xception {

	public:

		Xarning (const string& message);
		Xarning (const format& message);
};

//=== Ratio ================================================================
struct Ratio {

	double		m_numerator;
	double		m_denominator;

	Ratio (double numerator, double denominator);
};

namespace boost {

	template<> inline Ratio lexical_cast (const std::string& arg) throw (Xception)
	{
		string::size_type pos = arg.find('/');
		if (pos != string::npos)
			return Ratio(lexical_cast<double>(string(arg, 0, pos)), lexical_cast<double>(string(arg, pos + 1)));
		else
			throw Xception(format("not a Ratio value: %s") % arg);
	}

}

//=== other ================================================================
typedef size_t RGB;

const RGB NoColor = (RGB)-1;

typedef multi_array<any, 2> Selection;

#endif
