// This file is part of the pdr/pdx project.
// Copyright (C) 2010 Torsten Mueller, Bern, Switzerland
//
// This program is free software: you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation, either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#include "../libpdrx/common.h"

using namespace std;
using namespace boost;
using namespace boost::posix_time;
using namespace boost::gregorian;
using namespace boost::program_options;

#include "../libpdrx/datatypes.h"
#include "../libpdrx/config.h"
#include "db.h"
#include "out_impl.h"
#include "out_ftree.h"

//=== OutputInteractive ====================================================
OutputInteractive::OutputInteractive (const string& option_key)
	: OutputImpl(option_key)
{
}

void OutputInteractive::Do (const Config& config, const Database& database) const throw (Xception)
{
	cout << "pdx " << VERSION << ", interactive mode (press q to quit)" << endl;

	string line;
	while (true)
	{
		cout << "> ";
		if (!getline(cin, line))
			break;
		trim(line);
		if (line == "q")
			break;
		if (line.empty())
			continue;

		try
		{
			if (line[0] == '?')
			{
				line.erase(0, 1);
				trim(line);
				FExpr::fImplFactory.Help(cout, line);
				continue;
			}

			bool dot = false;
			if (line[0] == '.')
			{
				dot = true;
				line.erase(0, 1);
			}

			auto_ptr<FTree> ft(Parse(line));
			if (dot)
				cout << *ft; // dump structure
			else
			{
				FContext context(config, database);
				cout << ft->Evaluate(context) << endl;
			}
		}
		catch (Xception e)
		{
			cerr << e.Message() << endl;
		}
	}
}
