// This file is part of the pdr/pdx project.
// Copyright (C) 2010 Torsten Mueller, Bern, Switzerland
//
// This program is free software: you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation, either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef __DB_IMPL_H
#define __DB_IMPL_H

#include "db.h"

namespace Poco {
	namespace Data {
		class Session;
		class RecordSet;
	}
}

//=== DatabaseImpl (abstract base class) ===================================
class DatabaseImpl: public Database {

	protected:

	friend class DBFactory;

	virtual	void Connect () throw (Xception) =0;
};

#ifdef USE_SQLITE
//=== SQLiteDatabase =======================================================
class SQLiteDatabase: public DatabaseImpl {

	protected:

	friend class DBFactory;

	struct CollectionMetaInfo {
		string	m_collection;
		char	m_type;
		string	m_tblname;
	};

	struct less_cmi: public binary_function<const CollectionMetaInfo&, const CollectionMetaInfo&, bool> {
		result_type operator () (first_argument_type a, second_argument_type b) const
		{
			return a.m_collection < b.m_collection;
		}
	};

	typedef set<CollectionMetaInfo, less_cmi> CollectionMetaInfos;
	typedef map<string, shared_ptr<Selection> > Selections;

	string			m_connect;
	bool			m_verbose : 1;
	bool			m_fast : 1;
	Poco::Data::Session*	m_pSession;
	CollectionMetaInfos	m_collectionMetaInfos;
	mutable Selections	m_selections;

		SQLiteDatabase (const string& connect, bool verbose, bool fast);
	virtual	void Connect () throw (Xception);

	public:

	virtual	~SQLiteDatabase ();

	virtual void Select (shared_ptr<Selection>& selection, const string& collection, const ptime& begin, const ptime& end) const throw (Xception);
	virtual string GetVersion () const throw (Xception);
};
#endif

#ifdef USE_MYSQL
//=== MySQLDatabase ========================================================
class MySQLDatabase: public DatabaseImpl {

	protected:

	friend class DBFactory;

	struct CollectionMetaInfo {
		string	m_collection;
		char	m_type;
		string	m_tblname;
	};

	struct less_cmi: public binary_function<const CollectionMetaInfo&, const CollectionMetaInfo&, bool> {
		result_type operator () (first_argument_type a, second_argument_type b) const
		{
			return a.m_collection < b.m_collection;
		}
	};

	typedef set<CollectionMetaInfo, less_cmi> CollectionMetaInfos;
	typedef map<string, shared_ptr<Selection> > Selections;

	string			m_connect;
	bool			m_verbose : 1;
	bool			m_fast : 1;
	Poco::Data::Session*	m_pSession;
	CollectionMetaInfos	m_collectionMetaInfos;
	mutable Selections	m_selections;

		MySQLDatabase (const string& connect, bool verbose, bool fast);
	virtual	void Connect () throw (Xception);

	public:

	virtual	~MySQLDatabase ();

	virtual void Select (shared_ptr<Selection>& selection, const string& collection, const ptime& begin, const ptime& end) const throw (Xception);
	virtual string GetVersion () const throw (Xception);
};
#endif

#endif
