// This file is part of the pdr/pdx project.
// Copyright (C) 2010 Torsten Mueller, Bern, Switzerland
//
// This program is free software: you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation, either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef __DB_IMPL_H
#define __DB_IMPL_H

#include "db.h"

//=== DatabaseImpl (abstract base class) ===================================
class DatabaseImpl: public Database {

	protected:

	friend class DBFactory;

	virtual	void Connect () throw (Xception) =0;
};

//=== SQLiteDatabase =======================================================
namespace Poco {
	namespace Data {
		class Session;
		class RecordSet;
	}
}

class SQLiteDatabase: public DatabaseImpl {

	protected:

	friend class DBFactory;

	typedef map<string, char> CollectionTypes;

	string			m_connect;
	bool			m_verbose;
	Poco::Data::Session*	m_pSession;
	CollectionTypes		m_collectionTypes;

		SQLiteDatabase (const string& connect, bool verbose);
	virtual	void Connect () throw (Xception);

	public:

	virtual	~SQLiteDatabase ();

	virtual	void ListCollections () throw (Xception);
	virtual	void AddCollection (const string& name) throw (Xception);
	virtual	void DeleteCollection (const string& name) throw (Xception);
	virtual	void DeleteAllCollections () throw (Xception);
	virtual char GetCollectionType (const string& name) throw (Xception);

	virtual	void ListRejections () throw (Xception);
	virtual	void DeleteAllRejections () throw (Xception);

	virtual	void AddCollectionElements (const CollectionElements& elements) throw (Xception);
	virtual	void AddInserted (const ptime& timestamp, const string& expr) throw (Xception);
	virtual	void AddRejected (const ptime& timestamp, const string& expr) throw (Xception);
};

#endif
