--
--          This file is part of the New World OS and Objectify projects
--                  Copyright (C) 2006, 2007, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, and bug tracking
--   go to:
--      http://savannah.nongnu.org/projects/objectify
--
--   For releases from Alpha_30 and up, bug and feature request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-10-06 08:06:23 -0600 (Tue, 06 Oct 2009) $
--   $Revision: 4384 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.  I have kept the portion of the
--   old CVS log before this file was moved from the main directory.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
--
-- Revision 1.20  2006/11/11 12:29:18  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.19  2006/02/20 14:20:22  jsedwards
-- Added code to add reference to language.
--
-- Revision 1.18  2006/02/19 19:07:06  jsedwards
-- Wrapped debug print statement when object read in, in "debug" so they only
-- print when debug is passed to compiler.
--
-- Revision 1.17  2006/02/19 15:55:18  jsedwards
-- Changed the name of NWOS_HEADER to NWOS_OBJECT.
--
-- Revision 1.16  2006/02/19 03:43:20  jsedwards
-- Removed loop that loaded letter objects, they should be loaded when
-- accessed now.
--
-- Revision 1.15  2006/02/18 21:09:32  jsedwards
-- Changed attributes to routines that make sure the object is loaded before
-- returning the object.
--
-- Revision 1.14  2006/02/13 14:11:04  jsedwards
-- Changed "has" to accept any symbol as input to see if it is a letter of
-- this alphabet.
--
-- Revision 1.13  2006/02/11 22:16:35  jsedwards
-- Moved the loading of the letters outside of the loop that reads in the
-- letters.  We must have all 26 letters in the alphabet when the letters
-- are loaded because the spelling index uses the count of the alphabet to
-- fill in the next index table (if there is only 1 letter in the alphabet
-- it only reads 1 next index.
--
-- Revision 1.12  2006/02/11 18:24:48  jsedwards
-- Added a void reference after the letters in the alphabet so we know where
-- the end is.  Filled in the read from stream routine.  Commented out the
-- class invariant because if the object is made unresolved it fails.
--
-- Revision 1.11  2006/02/10 13:55:34  jsedwards
-- Changed "load" in creation clause to "make_unresolved".
--
-- Revision 1.10  2006/02/09 13:06:49  jsedwards
-- Added reference parameter to "initialize header" call and removed "next
-- identifier" feature that is now in nwos_header.  Changed to the new
-- method of doing the class defintion stuff, with the "class reference"
-- and "class revision".
--
-- Revision 1.9  2006/02/08 14:24:04  jsedwards
-- Added "load" to creation clause, a dummy read_body_from_stream routine,
-- and class reference to class definition "make" call.
--
-- Revision 1.8  2006/02/05 16:52:01  jsedwards
-- Added "has", "letter", and "index_of" features.
--
-- Revision 1.7  2006/02/05 14:01:02  jsedwards
-- Changed to use "next english ref" as the base for identifiers.
--
-- Revision 1.6  2006/02/05 04:41:51  jsedwards
-- Change to new format with real objects instead of just references and
-- new deferred class definition format.
--
-- Revision 1.5  2006/02/02 02:05:44  jsedwards
-- Removed passing class reference to "initialize header".
--
-- Revision 1.4  2006/01/31 19:27:51  jsedwards
-- Fixed class name.
--
-- Revision 1.3  2006/01/31 14:25:30  jsedwards
-- Add new class definition kludge.
--
-- Revision 1.2  2006/01/30 04:56:41  jsedwards
-- Fix to correctly write items to the stream.
--
-- Revision 1.1  2006/01/29 18:33:22  jsedwards
-- Initial version, untested!
--


class NWOS_ALPHABET

inherit NWOS_OBJECT

creation make, make_unresolved


feature

   language: NWOS_LANGUAGE is
      do
         load_if_not_already
         Result := language_obj
      ensure
         Result /= Void
      end

   letters: ARRAY[NWOS_LETTER] is
      do
         load_if_not_already
         Result := letters_obj
      ensure
         Result /= Void
      end


feature

   count: INTEGER is
      do
         Result := letters.count
      end

   lower: INTEGER is 1

   upper: INTEGER is
      do
         Result := count
      end

   has(symbol: NWOS_SYMBOL): BOOLEAN is
        -- symbol is a member of this alphabet
      local
         ltr: NWOS_LETTER
      do
         ltr ?= symbol  -- is it a letter?
         if ltr /= Void then  -- if it is, is it a member of this alphabet
            Result := letters.fast_has(ltr)
         end
      end

   item(index: INTEGER): NWOS_LETTER is
      require
         lower <= index and index <= upper
      do
         Result := letters.item(index)
      end

   put(ltr: NWOS_LETTER; index: INTEGER) is
      require
         lower <= index and index <= upper
      do
         letters.put(ltr, index)
      end

   letter(char: CHARACTER): NWOS_LETTER is
      -- translate an ASCII character to NWOS letter - probably need to do this some more universal way someday
      require
         'A' <= char and char <= 'Z'
            or else
         'a' <= char and char <= 'z'
      do
         Result := item(char.to_upper.code - ('A').code + lower)
      ensure
         Result /= Void
         index_of(Result) = char.to_upper.code - ('A').code + lower
      end

   index_of(ltr: like letter): INTEGER is
      require
         letters.fast_has(ltr)
      do
         Result := letters.fast_index_of(ltr)
      end

   write_body_to_stream(stream: BINARY_OUTPUT_STREAM) is
      local
         i: INTEGER
      do
         language_obj.class_definition.identifier.write_to_stream(stream)
         language_obj.identifier.write_to_stream(stream)

         from
            i := letters_obj.lower
         variant
            letters_obj.upper - i
         until
            i > letters_obj.upper
         loop
            letters_obj.item(i).class_definition.identifier.write_to_stream(stream)
            letters_obj.item(i).identifier.write_to_stream(stream)
            i := i + 1
         end

         Void_reference.write_to_stream(stream)
      end

   read_body_from_stream(stream: BINARY_INPUT_STREAM) is
      local
         ltr: NWOS_LETTER
         class_ref: NWOS_REFERENCE
         object_ref: NWOS_REFERENCE
      do
         !!class_ref.make_from_stream(stream)
         !!object_ref.make_from_stream(stream)

         language_obj ?= object_ref.get_object(class_ref)

         if language_obj = Void then
            std_error.put_string("NWOS_ALPHABET.read_body_from_stream: language failed to load%N")
            die_with_code(exit_failure_code)
         end

         !!letters_obj.with_capacity(32, 1)

         from
            !!class_ref.make_from_stream(stream)
         until
            class_ref.is_void
         loop
            !!object_ref.make_from_stream(stream)
debug
std_output.put_string("NWOS_ALPHABET.read_body_from_stream")
std_output.put_string("%N  class: ")
std_output.put_string(class_ref.to_string)
std_output.put_string("%N  object: ")
std_output.put_string(object_ref.to_string)
std_output.put_new_line
end
            ltr ?= object_ref.get_object(class_ref)

            if ltr = Void then
               std_error.put_string("NWOS_ALPHABET.read_body_from_stream: letter failed to load%N")
               die_with_code(exit_failure_code)
            end

            letters_obj.add_last(ltr)

            !!class_ref.make_from_stream(stream)
         end
debug
std_output.put_string("NWOS_ALPHABET.read_body_from_stream - letters: ")
std_output.put_integer(letters_obj.count)
std_output.put_new_line
end
      end

feature {NONE}

   make(lang: like language; size: INTEGER) is
      do
         initialize_header(next_english_identifier)

         language_obj := lang
         language_obj.add_reference(Current)

         !!letters_obj.make(1, size)
      end


feature {NONE}  -- actual values stored

   language_obj: like language

   letters_obj: like letters


feature {NONE}  -- once again the kludgy class definition stuff

   class_revision: STRING is
      once
         !!Result.copy("$Revision: 4384 $")
         Result.remove_prefix("$Revision: ")
         Result.remove_suffix(" $")
      end

   class_reference: NWOS_REFERENCE is
      do
         Result := Class_alphabet_ref
      end


--invariant

--   letters /= Void

end

