--
--          This file is part of the New World OS and Objectify projects
--                     Copyright (C) 2008, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, and bug tracking
--   go to:
--      http://savannah.nongnu.org/projects/objectify
--
--   For releases from Alpha_30 and up, bug and feature request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-10-06 08:06:23 -0600 (Tue, 06 Oct 2009) $
--   $Revision: 4384 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--


class PLAY_MUSIC

creation make

feature

   played_list: SONG_LIST

   playable(path: STRING): BOOLEAN is
      local
         i: INTEGER
      do
         if path.has_suffix(".mp3") or path.has_suffix(".ogg") then
            if argument_count = 0 then
               Result := not played_list.has(path)
            else
               from
                  i := 1
               until
                  Result or else i > argument_count
               loop
                  if path.has_string(argument(i)) then
                     Result := not played_list.has(path)
                  end
                  i := i + 1
               end
            end
         end
      end

   make is
      local
         assoc_class_def: CLASS_DEFINITION
	 assoc_obj: PATH_AND_FILE_ASSOCIATION
         path_obj: FILE_PATH
         tmp_path: STRING
         home_path: STRING
         command: STRING
         played_list_path: STRING
         i: INTEGER
	 it_is_cool: BOOLEAN
         
      do
         !!played_list.with_capacity(4000)

         if argument_count = 0 then
            home_path := get_environment_variable("HOME")

            if home_path = Void then
               std_error.put_string("ERROR: HOME environment variable is not set%N")
               die_with_code(exit_failure_code)
            end

            !!played_list_path.make(home_path.count)
            played_list_path.copy(home_path)
            played_list_path.append("/played_list.txt")
            if not played_list.read_list(played_list_path) then
               std_error.put_string("WARNING: could not open played list, starting from beginning%N")
            end
         end


         nwos_initialize_objectify(0x52454144, Void);

	 !!assoc_class_def.find("PATH AND FILE ASSOCIATION")

         if assoc_class_def.reference.is_void then
	     std_output.put_string("No files are stored in the system!%N")
         else
             std_output.put_string("Assoc class: ")
             assoc_class_def.reference.dump

             std_output.put_string("Number of files: ")
             std_output.put_integer(assoc_class_def.references.count)
             std_output.put_new_line

             !!tmp_path.make(24)
             !!command.make(48)

             from
                i := assoc_class_def.references.lower
             until
                i > assoc_class_def.references.upper
             loop
--                assoc_class_def.references.item(i).dump

                if assoc_class_def.references.item(i).object_class.is_equal(assoc_class_def.reference) then
                   !!assoc_obj.read_from_disk(assoc_class_def.references.item(i))
--                   std_output.put_string("path: ")
--                   assoc_obj.path.dump

                   !!path_obj.read_from_disk(assoc_obj.path)
--                   std_output.put_string(path_obj.path)
--                   std_output.put_new_line

                   if (playable(path_obj.path)) then
                      tmp_path.copy(path_obj.path)
                      tmp_path.fill('-')
                      tmp_path.extend('%N')
                      std_output.put_string(tmp_path)
                      std_output.put_string(path_obj.path)
                      std_output.put_new_line
                      std_output.put_string(tmp_path)

                      tmp_path.copy("/tmp/")
                      assoc_class_def.references.item(i).append_in(tmp_path)
                      if path_obj.path.has_suffix(".mp3") then
                         tmp_path.append(".mp3")
                         command.copy("mpg321 ")
                      else
                         tmp_path.append(".ogg")
                         command.copy("ogg123 ")
                      end
                      std_output.put_string(tmp_path)
                      std_output.put_new_line

                      if nwos_restore_file(assoc_class_def.references.item(i).to_external, tmp_path.to_external) then
                         command.append(tmp_path)
                         system(command)
                         remove_file(tmp_path)

                         if argument_count = 0 then
                            std_output.put_string("%N Last: ")
                            std_output.put_string(path_obj.path)
                            std_output.put_string("%N%N")

                            from
                               it_is_cool := False
                            until
                               it_is_cool
                            loop
                               std_output.put_string("rating (0-9): ")
                               std_output.flush

                               command.clear
                               std_input.read_line_in(command)

                               if command.count = 1 and then command.first.in_range('0', '9') then
                                  played_list.add_last(path_obj.path, command.first)
                                  if not played_list.write_list(played_list_path) then
                                     std_error.put_string("ERROR: could not write played list file%N")
                                     nwos_terminate_objectify;
                                     die_with_code(exit_failure_code)
                                  end
                                  it_is_cool := true
                               else
                                  std_output.put_string("%NPlease enter a digit between 0 and 9%N%N")
                               end
                            end

                            from
                               it_is_cool := false
                            until
                               it_is_cool
                            loop
                               std_output.put_string("what?: ")
                               std_output.flush

                               command.clear
                               std_input.read_line_in(command)
                               command.to_lower

                               if command.is_equal("q") then
                                  i := assoc_class_def.references.upper + 1
                                  it_is_cool := True
                               elseif command.is_equal("b") then
                                  i := assoc_class_def.references.lower
                                  std_output.put_string("Replay: ")
                                  std_output.put_string(played_list.last)
                                  std_output.put_new_line
                                  played_list.remove_last
                                  command.clear
                               elseif command.is_equal("c") then
                                  it_is_cool := True
                               else
                                  std_output.put_string("Please enter 'b' for back, 'c' for continue or 'q' to quit%N")
                               end
                            end
                            i := i - 1
                         end
                      else
                         std_error.put_string("Error could not read file: ")
                         std_error.put_string(path_obj.path)
                         nwos_terminate_objectify;
                         die_with_code(exit_failure_code)
                      end
                   end
                end

                i := i + 1
             end
         end

         nwos_terminate_objectify;
      end

   nwos_initialize_objectify(mode: UNSIGNED; path: STRING) is
      external "C"
      end

   nwos_restore_file(assoc_ref: POINTER;  path: POINTER): BOOLEAN is
      external "C"
      end

   nwos_terminate_objectify is
      external "C"
      end

   get_unix_time: INTEGER is
      external "C"
      end     

end


