/*
--             This file is part of the New World OS project
--                 Copyright (C) 2004-2009  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: reference.h,v $
-- Revision 1.9  2009/04/13 14:20:55  jsedwards
-- Moved Reference_Type back from types.h.  This revision is the same as 1.7.
--
-- Revision 1.8  2009/04/13 12:27:22  jsedwards
-- Moved Reference_Type definition to types.h file.
--
-- Revision 1.7  2009/04/11 21:21:18  jsedwards
-- Moved the reference related defines from the disk_io.h file.
--
-- Revision 1.6  2009/03/13 04:48:47  jsedwards
-- Moved various declarations from objectify.h.
--
*/


#ifndef REFERENCE_H
#define REFERENCE_H

#include "types.h"


#define RESERVED_PUBLIC_BLOCKS    0x10000000    /* IDs 0x00000000 to 0x0fffffff reserved */
#define RESERVED_PRIVATE_BLOCKS   0xeff00000    /* IDs 0x10000000 to 0xfff00000 reserved */
#define RESERVED_TEMPORARY_BLOCKS 0x00100000    /* IDs 0xfff00000 to 0xffffffff reserved */


/* some blocks don't come out even when dividing usable chunks per block, so don't allocate them */

#define RESERVED_PRIVATE_CHUNKS (RESERVED_PRIVATE_BLOCKS / USABLE_BLOCKS_PER_CHUNK)
/*                              (0xeff00000              / 65504)    = 61454 */

#define MAXIMUM_PUBLIC_REFERENCE   (RESERVED_PUBLIC_BLOCKS - 1)

#define MINIMUM_PRIVATE_REFERENCE  RESERVED_PUBLIC_BLOCKS

/* USE THIS in Alpha_30: */
#define MAXIMUM_PRIVATE_REFERENCE (RESERVED_PUBLIC_BLOCKS + RESERVED_PRIVATE_BLOCKS - 1)
/*                                             0x10000000 + 0xeff00000 - 1   = 0xffefffff */

/* THIS IS ONLY FOR Alpha_29 */
//#define MAXIMUM_PRIVATE_REFERENCE (RESERVED_PUBLIC_BLOCKS + (RESERVED_PRIVATE_CHUNKS * USABLE_BLOCKS_PER_CHUNK) - 1) /* 0xffeffe40 */

#define MINIMUM_TEMPORARY_REFERENCE (RESERVED_PUBLIC_BLOCKS + RESERVED_PRIVATE_BLOCKS)
#define MAXIMUM_TEMPORARY_REFERENCE (RESERVED_PUBLIC_BLOCKS + RESERVED_PRIVATE_BLOCKS + (RESERVED_TEMPORARY_BLOCKS - 1))



typedef enum { Unknown_Reference, Public_Reference, Private_Reference, Temporary_Reference } Reference_Type;

typedef union { uint8 id[4]; uint32 word; } ObjRef;

static inline bool is_void_reference(ObjRef* ref)
{
    int i;
    for (i = 0; i < sizeof(ObjRef); i++) if (ref->id[i] != 0) return false;
    return true;
}


static inline bool is_same_object(ObjRef* ref1, ObjRef* ref2)
{
    int i;
    for (i = 0; i < sizeof(ObjRef); i++) if (ref1->id[i] != ref2->id[i]) return false;
    return true;
}


static inline void copy_reference(ObjRef* dst, ObjRef* src)
{
    int i;
    for (i = 0; i < sizeof(ObjRef); i++) dst->id[i] = src->id[i];
}


static inline void void_reference(ObjRef* ref)
{
    int i;
    for (i = 0; i < sizeof(ObjRef); i++) ref->id[i] = 0;
}


/* NOTE: these only work when references are 4 bytes, need to fix when size is changed */
static inline uint32 nwos_ref_to_word(ObjRef* ref) 
{
  return ((uint32)ref->id[0] << 24) | ((uint32)ref->id[1] << 16) | ((uint32)ref->id[2] << 8) | (uint32)ref->id[3];
}

static inline void nwos_word_to_ref(uint32 word, ObjRef* ref) 
{
    ref->id[0] = word >> 24;
    ref->id[1] = word >> 16;
    ref->id[2] = word >> 8;
    ref->id[3] = word;
}

extern bool nwos_is_public_reference(ObjRef* ref);
extern bool nwos_is_private_reference(ObjRef* ref);
extern bool nwos_is_temporary_reference(ObjRef* ref);
extern Reference_Type nwos_reference_type(ObjRef* ref);

#endif

