/*
--         This file is part of the New World OS and Objectify projects
--                       Copyright (C) 2009  QRW Software
--              J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                         http://www.qrwsoftware.com
--                         http://nwos.sourceforge.com
--                      http://objectify.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: dialog.c,v $
-- Revision 1.2  2009/06/13 11:37:25  jsedwards
-- Merged changes from Alpha_29.10 branch (version Alpha_29.11).
--
-- Revision 1.1.2.2  2009/06/06 18:16:38  jsedwards
-- Fix Bug #2740516 - Added new get_answer function that calls fgets and
-- checks return value.
--
-- Revision 1.1.2.1  2009/06/06 17:55:09  jsedwards
-- New file created from old get_input function removed from several files (it
-- was duplicated) and renamed.  Also moved nwos_ask_yes_or_no function from
-- objectify.c.
--
*/

#include <ctype.h>
#include <stdio.h>
#include <string.h>

#include "objectify.h"


static void get_answer(char* buffer, size_t bufsize)
{
    if (fgets(buffer, bufsize, stdin) == NULL)
    {
	fputc('\n', stderr);

	if (feof(stdin))
	{
	    fprintf(stderr, "ERROR: received end of input from standard input\n");
	}
	else
	{
	    perror("reading answer to question");
	}

	exit(1);
    }
}


void nwos_ask_user(char* descr, char* buffer, size_t size)
{
    char *ptr;

    while (1)
    {
	printf("%s: ", descr);
	fflush(stdout);

	get_answer(buffer, size);

	ptr = strchr(buffer, '\n');

	if (ptr != NULL)
	{
	    *ptr = '\0';
	    break;
	}

	do { get_answer(buffer, size); } while (strchr(buffer, '\n') == NULL);

	printf("input too long, maximum length: %zd - try again!\n", size);
    }
}


bool nwos_ask_yes_or_no(char* statement, char* question)
{
    char buffer[16];

    if (statement != NULL)
    {
	printf("%s.  %s? (y/n): ", statement, question);
    }
    else
    {
	printf("%s? (y/n): ", question);
    }

    while (1)
    {
	fflush(stdout);
	get_answer(buffer, sizeof(buffer));
	printf("\n");

	if (strchr(buffer, '\n') == NULL)  /* too much input */
	{
	    while (strchr(buffer, '\n') == NULL) get_answer(buffer, sizeof(buffer));
	    buffer[0] = '\0';
	}

	if (strcasecmp(buffer, "y\n") == 0 || strcasecmp(buffer, "yes\n") == 0) break;

	if (strcasecmp(buffer, "n\n") == 0 || strcasecmp(buffer, "no\n") == 0) break;

	printf("Please answer the question: %s (yes or no)\n", question);
    }

    return (tolower(buffer[0]) == 'y');
}


