--
--          This file is part of the New World OS and Objectify projects
--                     Copyright (C) 2007, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, and bug tracking
--   go to:
--      http://savannah.nongnu.org/projects/objectify
--
--   For releases from Alpha_30 and up, bug and feature request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-10-06 08:06:23 -0600 (Tue, 06 Oct 2009) $
--   $Revision: 4384 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
--
-- This program generates N number of test files in the given directory.
--

class GEN_N_FILES

creation make

feature

   make is
      local
         number: INTEGER
         i: INTEGER
         path: STRING
      do
         if argument_count /= 2 or else not argument(1).is_integer then
            std_error.put_string("usage: ")
            std_error.put_string(argument(0))
            std_error.put_string(" number-of-files directory%N")
            die_with_code(exit_failure_code)
         end

         number := argument(1).to_integer

         !!path.make(argument(2).count + 16)

         from
            i := 1
         variant
            number - i
         until
            i > number
         loop
            path.copy(argument(2))

            if path.last /= '/' then
               path.extend('/')
            end

            path.append("file")

            if i < 10 then
               path.append("000")
            elseif i < 100 then
               path.append("00")
            elseif i < 1000 then
               path.append("0")
            end

            i.append_in(path)

            path.append(".txt")

            file.connect_to(path)

            if not file.is_connected then
               std_error.put_string("Unable to open file: ")
               std_error.put_string(path)
               std_error.put_new_line
               die_with_code(exit_failure_code)
            end

            file.put_string("This is file number: ")
            file.put_integer(i)
            file.put_new_line

            file.disconnect

            i := i + 1
         end
      end

   file: STD_FILE_WRITE is
      once
         !!Result.make
      end

end

