/*
--          This file is part of the New World OS and Objectify projects
--            Copyright (C) 2005, 2006, 2007, 2008, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, and bug tracking
--   go to:
--      http://savannah.nongnu.org/projects/objectify
--
--   For releases from Alpha_30 and up, bug and feature request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-10-06 08:06:23 -0600 (Tue, 06 Oct 2009) $
--   $Revision: 4384 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revisions of this file and the disk_io.h which this file was
--   created from.  Also see the log in the disk_io.h file itself from when it
--   was named objectify_private.h.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
*/

#ifndef CLASS_DEFINITION_H
#define CLASS_DEFINITION_H

#include "objectify.h"


#define MAX_CLASS_DEFINITION_OBJ_SIZE (sizeof(C_struct_Class_Definition) + sizeof(ObjRef) * 100)    /* for now assume 100 features max */
#define MAX_FEATURE_NAME_OBJ_SIZE     (sizeof(C_struct_Name) + sizeof(ObjRef) * 24)                 /* for now assume 24 words in a name max */


extern ObjRef nwos_public_class_definition_class_ref;
extern ObjRef nwos_private_class_definition_class_ref;
extern ObjRef nwos_reference_list_class_ref;

extern void nwos_create_class_definition(char* name_of_class);
extern void nwos_clone_class_definition(ObjRef* class_to_clone_ref, ObjRef* clone_ref);

#define NUM_FILE_CLASS_DEFINITIONS  3

extern ObjRef* nwos_get_file_001_reference();
extern ObjRef* nwos_get_file_002_reference();
extern ObjRef* nwos_get_file_class_reference();


#endif

