--
--          This file is part of the New World OS and Objectify projects
--                  Copyright (C) 2006, 2007, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, and bug tracking
--   go to:
--      http://savannah.nongnu.org/projects/objectify
--
--   For releases from Alpha_30 and up, bug and feature request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-10-06 08:06:23 -0600 (Tue, 06 Oct 2009) $
--   $Revision: 4384 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.  I have kept the portion of the
--   old CVS log before this file was moved from the main directory.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
--
-- Revision 1.13  2006/11/11 12:29:19  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.12  2006/02/26 15:41:40  jsedwards
-- Removed spelling, because in the case of nouns there needs to be a singular
-- and plural spelling.
--
-- Revision 1.11  2006/02/25 04:45:47  jsedwards
-- Changed to inherit from NWOS_THING and have it's own class definition
-- created.
--
-- Revision 1.10  2006/02/20 05:38:30  jsedwards
-- Added new "append_in" feature and "to_string" calls it now.
--
-- Revision 1.9  2006/02/20 05:02:41  jsedwards
-- Added "to_string" feature.
--
-- Revision 1.8  2006/02/19 18:06:40  jsedwards
-- Changed attributes to routines tham make sure the object is loaded before
-- returning value.  Also filled in the read_body_from_stream routine.
--
-- Revision 1.7  2006/02/19 15:55:18  jsedwards
-- Changed the name of NWOS_HEADER to NWOS_OBJECT.
--
-- Revision 1.6  2006/02/16 03:03:26  jsedwards
-- Changed to pass the spelling object to "make" instead of the letters.
--
-- Revision 1.5  2006/02/11 18:40:50  jsedwards
-- Commented out the class invariant because it fails when the object is
-- created with make_unresolved.
--
-- Revision 1.4  2006/02/09 05:41:05  jsedwards
-- Added reference parameter to initialize_header call and removed
-- next_identifier feature that is now in nwos_header.
--
-- Revision 1.3  2006/02/08 14:17:25  jsedwards
-- Add dummy read_body_from_stream routine.
--
-- Revision 1.2  2006/02/05 16:56:08  jsedwards
-- Made it real (instead of all commented out stuff).
--
-- Revision 1.1  2006/02/05 05:09:38  jsedwards
-- Initial version, incomplete.
--

deferred class NWOS_WORD

inherit NWOS_THING


feature

   references: ARRAY[NWOS_OBJECT] is
      do
         load_if_not_already
         Result := references_obj
      ensure
         Result /= Void
      end


feature 

   to_string(char_set: NWOS_REFERENCE): STRING is
        -- convert this word to a string in the current character set
      do
         !!Result.make(spelling.count)  -- this isn't going to be correct if utf8 is used
         append_in(char_set, Result)
      end

   append_in(char_set: NWOS_REFERENCE; string: STRING) is
        -- append this word into a string in the current character set
      local
         i, j: INTEGER
         codes: ARRAY[CHARACTER]
      do
         from
            i := spelling.lower
         until
            i > spelling.upper
         loop
            codes := spelling.item(i).to_codes(Class_ascii_character_ref)

            from
               j := codes.lower
            until
               j > codes.upper
            loop
               string.extend(codes.item(j))
               j := j + 1
            end

            i := i + 1
         end
      end


feature {NONE}

   write_body_to_stream(stream: BINARY_OUTPUT_STREAM) is
      local
         i: INTEGER
      do
         spelling_obj.class_definition.identifier.write_to_stream(stream)
         spelling_obj.identifier.write_to_stream(stream)

         write_names_to_stream(stream)

         from
            i := references_obj.lower
         variant
            references_obj.upper - i
         until
            i > references_obj.upper
         loop
            references_obj.item(i).class_definition.identifier.write_to_stream(stream)
            references_obj.item(i).identifier.write_to_stream(stream)
            i := i + 1
         end

         Void_reference.write_to_stream(stream)
      end

   read_body_from_stream(stream: BINARY_INPUT_STREAM) is
      local
         obj: NWOS_OBJECT
         class_ref: NWOS_REFERENCE
         object_ref: NWOS_REFERENCE
      do
         !!class_ref.make_from_stream(stream)
         !!object_ref.make_from_stream(stream)

         spelling_obj ?= object_ref.get_object(class_ref)

         if spelling_obj = Void then
            std_error.put_string("NWOS_WORD.read_body_from_stream: spelling failed to load%N")
            die_with_code(exit_failure_code)
         end

         class_ref := read_names_from_stream(stream)

         !!references_obj.with_capacity(8, 1)

         from
            -- read_names returned it
         until
            class_ref.is_void
         loop
            !!object_ref.make_from_stream(stream)

std_output.put_string("NWOS_WORD.read_body_from_stream")
std_output.put_string("%N  class: ")
std_output.put_string(class_ref.to_string)
std_output.put_string("%N  object: ")
std_output.put_string(object_ref.to_string)
std_output.put_new_line

            obj := object_ref.get_object(class_ref)
            references_obj.add_last(obj)

            !!class_ref.make_from_stream(stream)
         end
      end


feature {NONE}

   make(alphabet: NWOS_ALPHABET; spell: NWOS_SPELLING) is
      do
         initialize_header(next_english_identifier)
         spelling_obj := spell
         spelling_obj.add_reference(Current)
         !!references_obj.with_capacity(2, 1)  -- for now
      end


feature {NONE}  -- actual storage

   references_obj: like references


feature {NONE}  -- once again the kludgy class definition stuff

   class_revision: STRING is
      once
         !!Result.copy("$Revision: 4384 $")
         Result.remove_prefix("$Revision: ")
         Result.remove_suffix(" $")
      end

   class_reference: NWOS_REFERENCE is
      do
         Result := Class_word_ref
      end

--invariant

--   spelling /= Void
--   references /= Void

end

