/*
--          This file is part of the New World OS and Objectify projects
--         Copyright (C) 2004, 2005, 2006, 2007, 2008, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, and bug tracking
--   go to:
--      http://savannah.nongnu.org/projects/objectify
--
--   For releases from Alpha_30 and up, bug and feature request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-10-06 08:06:23 -0600 (Tue, 06 Oct 2009) $
--   $Revision: 4384 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revisions of this file and the disk_io.h which this file was
--   created from.  Also see the log in the disk_io.h file itself from when it
--   was named objectify_private.h.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
*/


#ifndef CHUNK_INFO_H
#define CHUNK_INFO_H

#include "reference.h"


#define USABLE_BLOCKS_PER_CHUNK 65536

#define BIT_MAP_BYTES (USABLE_BLOCKS_PER_CHUNK / 8)
#define BIT_MAP_BLOCKS (BIT_MAP_BYTES / FILE_BLOCK_SIZE)

#define BLOCKS_IN_CHUNK (BIT_MAP_BLOCKS + USABLE_BLOCKS_PER_CHUNK)

#define CHUNK_SIZE (BLOCKS_IN_CHUNK * FILE_BLOCK_SIZE)



typedef struct {
  uint64 ref;                              /* 8  */
  uint32 flags_used;                       /* 12  */
  uint32 index;                            /* 16 */
  uint8  md5_digest[MD5_DIGEST_SIZE];      /* 32 */
} Chunk_Info;
 
typedef struct {
  uint32 ref;                              /* 4 */
  uint16 used;                             /* 6 */
  uint16 index;                            /* 8 */
} Chunk_Info_0029;


#define CHUNK_INFO_USED_MASK           0x0001FFFF
#define CHUNK_INFO_FULL_MASK           0x00010000
#define CHUNK_INFO_MD5_VERIFIED_MASK   0x80000000


extern Chunk_Info* nwos_chunk_info;


extern void nwos_initialize_chunk_info(void);
extern void nwos_terminate_chunk_info(void);
extern void nwos_update_chunk_info_reverse_index();
extern int  nwos_chunk_index_to_info_index(uint16 chunk_index);
extern int  nwos_uint32_ref_to_info_index(uint32 ref);

extern uint32 nwos_hash_uint32_ref(uint32 ref);
extern uint32 nwos_hash_ref(ObjRef* ref);
extern off_t  nwos_ref_to_offset(ObjRef* ref);

extern void nwos_clear_chunk_digest(ObjRef* ref);

extern void nwos_allocate_new_chunk(uint32 ref);

extern uint32 nwos_blocks_used_in_chunk(int info_index);        /* returns the number of blocks used in chunk */
extern bool   nwos_chunk_is_full(int info_index);               /* returns true if chunk is full */

extern bool nwos_chunk_md5_has_been_verified(int info_index);          /* chunk MD5 checksum has been verified */
extern void nwos_set_chunk_md5_verified(int info_index);
extern void nwos_clear_chunk_md5_verified(int info_index);

extern void nwos_increment_chunk_info_block_used(int info_index);
extern void nwos_decrement_chunk_info_block_used(int info_index);
extern void nwos_reset_chunk_info_blocks_used(int info_index, uint32 blocks_used);

#endif

