/*
--          This file is part of the New World OS and Objectify projects
--                  Copyright (C) 2006, 2007, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, and bug tracking
--   go to:
--      http://savannah.nongnu.org/projects/objectify
--
--   For releases from Alpha_30 and up, bug and feature request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-10-06 08:06:23 -0600 (Tue, 06 Oct 2009) $
--   $Revision: 4384 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
*/

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "predefined_references.h"

char* attribute_revision = "$Revision: 4384 $";


/*---------------------------------------------------------------------------------------------------------
  attribute definition:

    definition attribute:     attribute
    creation attribute:       log
    name attribute:           name list   -- optional, only present if name is different than type
    plurality attribute:      single or multiple
    presence attribute:       required or optional
    mutability/modifiability attribute: fixed/frozen or addable/changeable
    type attribute:           definition of type
---------------------------------------------------------------------------------------------------------*/

void create_attribute(const reference id, const reference log, const reference presence, 
		      const reference multiplicity, const reference mutability, const reference type)
{
    char path[NWOS_PATH_MAX];
    FILE* fp;

    nwos_ref_to_path(id, path);

    fp = fopen(path, "wb");

    if (fp == NULL)
    {
	perror(path);
	exit(1);
    }

    write_file_header(id, fp);

    write_pair(Ref_attr_definition,   Ref_def_attribute, fp);
    write_pair(Ref_attr_creation,     log, fp);
    write_pair(Ref_attr_presence,     presence, fp);
    write_pair(Ref_attr_multiplicity, multiplicity, fp);
    write_pair(Ref_attr_mutability,   mutability, fp);
    write_pair(Ref_attr_type,         type, fp);

    if (fclose(fp) != 0)
    {
	perror(path);
	exit(1);
    }
}


/*---------------------------------------------------------------------------------------------------------
  definition definition:

    definition attribute:     definition (points to itself)
    creation attribute:       log
    name attribute:           attribute
    attribute attribute:      attribute definition
---------------------------------------------------------------------------------------------------------*/

void create_definition(const reference id, const reference log, const reference description, 
		       const reference implemenation, const reference inherit, const reference* attributes[])
{
    char path[NWOS_PATH_MAX];
    FILE* fp;
    int i;

    nwos_ref_to_path(id, path);

    fp = fopen(path, "wb");

    if (fp == NULL)
    {
	perror(path);
	exit(1);
    }

    write_file_header(id, fp);

    write_pair(Ref_attr_definition,    Ref_def_definition, fp);
    write_pair(Ref_attr_creation,      log, fp);
    write_pair(Ref_attr_description,   description, fp);

    write_pair(Ref_attr_implementation, implemenation, fp);
    if (memcmp(inherit, Ref_void, sizeof(reference)) != 0)
    {
	write_pair(Ref_attr_inherit, inherit, fp);
    }

    for (i = 0; attributes[i] != NULL; i++)
    {
	write_pair(Ref_attr_attribute, *attributes[i], fp);
    }

    if (fclose(fp) != 0)
    {
	perror(path);
	exit(1);
    }
}


