/*
--          This file is part of the New World OS and Objectify projects
--                        Copyright (C) 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, and bug tracking
--   go to:
--      http://savannah.nongnu.org/projects/objectify
--
--   For releases from Alpha_30 and up, bug and feature request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2010-01-23 10:02:35 -0700 (Sat, 23 Jan 2010) $
--   $Revision: 4492 $
--
--  This program takes a swizzle table generated by the test_random program
--  and outputs the md5 sums of each table (not including the eight zeros).
--
*/


#include <assert.h>
#include <stdio.h>
#include <string.h>

#include "types.h"
#include "md5.h"

uint8 correct[256];

bool check_block(uint8 block[])
{
    uint8 check[256];
    int i;

    if (correct[0] != 8)
    {
	correct[0] = 8;
	for (i = 1; i < 8; i++) correct[i] = 0;
	for (i = 8; i < 256; i++) correct[i] = 1;
    }

    memset(check, 0, sizeof(check));

    for (i = 0; i < 256; i++) check[block[i]]++;

    return memcmp(check, correct, 256) == 0;
}
 

int main(int argc, char* argv[])
{
    int argi;
    int seq;
    int i;
    FILE* fp;
    uint8 block[256];
    uint8  md5_digest[MD5_DIGEST_SIZE];      /* 32 */
    struct md5_ctx md5_context;    /* MD5 checksum context */

    for (argi = 1; argi < argc; argi++)
    {
	fp = fopen(argv[argi], "r");

	if (fp == NULL)
	{
	    perror(argv[argi]);
	}
	else
	{
	    printf("File: %s\n", argv[argi]);

	    for (seq = 0; seq < 4096; seq++)
	    {
		if (fread(block, 1, sizeof(block), fp) != sizeof(block))
		{
		    perror(argv[argi]);
		    break;
		}

		if (check_block(block))
		{
		    md5_init_ctx(&md5_context);   /* initialize the MD5 checksum context */
		    md5_process_bytes(&block[8], 256 - 8, &md5_context);
		    md5_finish_ctx(&md5_context, md5_digest);   /* finish computing the md5 sum */

		    for (i = 0; i < 16; i++) printf("%02x", md5_digest[i]);
		    printf("\n");
		}
		else
		  {
		    printf("Error seq %03x:\n", seq);
		    for (i = 0; i < 16; i++) printf("%02x%c", block[i], i%16==15?'\n':' ');
		  }
	    }

	    fclose(fp);
	}
    }

    return 0;
}


