--
--          This file is part of the New World OS and Objectify projects
--                        Copyright (C) 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, and bug tracking
--   go to:
--      http://savannah.nongnu.org/projects/objectify
--
--   For releases from Alpha_30 and up, bug and feature request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author$
--   $Date$
--   $Revision$
--
--  This program takes a swizzle table generated by the test_random program
--  and outputs the md5 sums of each table (not including the eight zeros).
--

class CHKDUP

creation make

feature

   make is
      local
         line1: STRING
         line2: STRING
         dups: INTEGER
         diff: INTEGER
      do
         !!line1.make(64)
         !!line2.make(64)

         from
            std_input.read_line_in(line1)
         until
            std_input.end_of_input
         loop
            std_input.read_line_in(line2)

            if line2.is_equal(line1) then
               dups := dups + 1
               std_output.put_string("Duplicate: ")
               std_output.put_string(line1)
               std_output.put_new_line
            else
               diff := diff + 1
            end

            line1.copy(line2)            
         end

         std_output.put_string("Duplicates: ")
         std_output.put_integer(dups)
         std_output.put_new_line
         std_output.put_string("Different: ")
         std_output.put_integer(diff)
         std_output.put_new_line
      end

end

