/*
--          This file is part of the New World OS and Objectify projects
--                     Copyright (C) 2008, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, bug and feature
--   request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-07-25 17:25:15 -0600 (Sat, 25 Jul 2009) $
--   $Revision: 4184 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
*/


#include <stdio.h>
#include <string.h>

#include "objectify.h"

struct whatever
{
  char* input;
  char* output;
} test_data[] = {
   { "a",                  "a" },
   { "a/",                 "a" },
   { ".a",                 ".a" },
   { "./a",                "a" },
   { "./a/",               "a" },
   { "a//",                "a" },
   { "a///",               "a" },
   { "a/////////////////", "a" },

   { "ab",                 "ab" },
   { ".ab",                ".ab" },
   { "ab/",                "ab" },
   { ".ab/",               ".ab" },

   { "ab",                 "ab" },
   { ".ab",                ".ab" },
   { "..ab",               "..ab" },
   { "ab/",                "ab" },
   { ".ab/",               ".ab" },
   { "..ab/",              "..ab" },
   { "ab.",                "ab." },
   { "ab./",               "ab." },
   { "ab..",               "ab.." },
   { "ab../",              "ab.." },

   { "abc",                "abc" },
   { "abc//",               "abc" },

   { "abc/def",            "abc/def" },
   { "abc/def////",        "abc/def" },
   { "abc//def/",          "abc/def" },
   { "abc///def/////////", "abc/def" },
   { "abc////////////def", "abc/def" },

   { "abc/def/ghi",        "abc/def/ghi" },
   { "abc//def/ghi",       "abc/def/ghi" },
   { "abc/def//ghi",       "abc/def/ghi" },
   { "abc//def//ghi",      "abc/def/ghi" },
   { "abc///def///ghi",    "abc/def/ghi" },
   { "abc////def////ghi",  "abc/def/ghi" },

   { ".",                  "." },
   { "./",                 "." },
   { "./.",                "." },
   { "././",               "." },
   { ".//.",               "." },
   { ".//./",              "." },
   { ".//.//",             "." },
   { ".///.",              "." },
   { ".///./",             "." },
   { ".///.///",           "." },
   { "././//////////////", "." },
   { ".///////////////./", "." },
   { ".////.////.///././", "." },

   { "..",                 ".." },
   { "../",                ".." },
   { "./..",               ".." },
   { "./../",              ".." },
   { "../.",               ".." },
   { "..//",               ".." },
   { "..//.",              ".." },
   { "..//./",             ".." },
   { "..//.//",            ".." },
   { ".././././",          ".." },
   { "..///",              ".." },
   { "..///.",             ".." },
   { "..///////////////.", ".." },
   { "../////////.////./", ".." },
   { ".././/////////////", ".." },
   { "..////.//.////.///", ".." },
   { "..////.//.//././/.", ".." },

   { "abc/../..",          ".." },
   { "abc/../../",         ".." },
   { "abc/..//..",         ".." },
   { "abc/..//..//",       ".." },
   { "../abc/..",          ".." },
   { "../abc/../",         ".." },
   { "../abc/../..",       "../.." },
   { "../abc/../../",      "../.." },
   { "./abc/..//..",       ".." },
   { "./abc/..//..//",     ".." },
   { "abc/../../.",        ".." },
   { "abc/../.././",       ".." },
   { "abc/..//../.",       ".." },
   { "abc/..//..//./.",    ".." },
   { "abc/..//.//../.",    ".." },
   { "abc/.//..//../.",    ".." },
   { "abc/..//.//..",      ".." },
   { "abc/..//.//../",     ".." },
   { "../abc/../.",        ".." },
   { "../abc/.././",       ".." },
   { "../abc/./../..",     "../.." },
   { ".././abc/../../",    "../.." },
   { "./../abc//..",       ".." },
   { "././../abc/..//",    ".." },

   { "abc/../def/..",      "." },
   { "abc/..//def/../",    "." },
   { "abc//def/../..",     "." },
   { "abc/def/../../",     "." },
   { "abc/../../def",      "../def" },
   { "abc//..//..//def/",  "../def" },
   { "abc/./def/..",       "abc" },
   { "abc/./def/../",      "abc" },
   { "abc/def/../ghi",     "abc/ghi" },
   { "abc/./def/../ghi/",  "abc/ghi" },
   { "abc/./def/..",       "abc" },
   { "abc/./def/../",      "abc" },
   { "abc/../def",         "def" },
   { "abc/../def/",        "def" },
   { "abc/.././def",       "def" },
   { "abc/.././def/",      "def" },

   { "../..",              "../.." },
   { "../../",             "../.." },
   { ".././..",            "../.." },
   { "..//..",             "../.." },
   { "../../.",            "../.." },
   { "..//.//..",          "../.." },
   { "..//.//../",         "../.." },
   { "../././..",          "../.." },
   { "../././../",         "../.." },
   { "..///..",            "../.." },
   { "..///../",           "../.." },
   { "..//////////////..", "../.." },
   { "..//////..//.///./", "../.." },
   { "..////////..//////", "../.." },
   { "..////.//.////..//", "../.." },
   { "..///.//.//././/..", "../.." },
   { "..//.//.//././/../", "../.." },
};

#define NUM_TESTS (sizeof(test_data)/sizeof(struct whatever))

int main()
{
    int i;
    char path[128];
    int result = 0;

    for (i = 0; i < NUM_TESTS; i++)
    {
	printf("%s -> ", test_data[i].input);
	fflush(stdout);

	nwos_normalize_path(path, test_data[i].input, sizeof(path));

	printf("%s", path);
	fflush(stdout);

	if (strcmp(path, test_data[i].output) != 0)
	{
	    printf("   Expected: %s", test_data[i].output);
	    result = 1;
	}

	printf("\n");
    }

    return result;
}


