/*
--          This file is part of the New World OS and Objectify projects
--               Copyright (C) 2006, 2007, 2008, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, bug and feature
--   request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-08-02 10:15:16 -0600 (Sun, 02 Aug 2009) $
--   $Revision: 4237 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revisions of this file, the log.c file, and the objectify.c file.
--   Also since this file was originally created from the strlcat.c and
--   strlcpy.c files, I left the parts of the log from those files below.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
-- Revision 1.1  2009/03/08 19:15:47  jsedwards
-- Moved strlcpy function from log.c file.
--
-- Revision 1.1  2009/03/08 19:15:29  jsedwards
-- Moved strlcat function from log.c file.
--
*/

#include <assert.h>

#include "strlcxx.h"

#ifndef HAVE_STRLCAT

#include <string.h>



/* From the OpenBSD man page:                                                        */
/*                                                                                   */
/* The strlcat() function appends the NUL-terminated string src to the end of dst.   */
/* It will append at most size - strlen(dst) - 1 bytes, NUL-terminating the result.  */

size_t strlcat(char* dst, const char* src, size_t size)
{
    int i, j;

    assert(size > 0);

    /* find the end of the destination string */
    /* if we don't find the null before size, don't write a zero */
    for (i = 0; dst[i] != '\0'; i++)
    {
	if (i >= size)
	{
	    return size + 1 + strlen(src);
	}
    }

    for (j = 0; src[j] != '\0'; j++)
    {
	if (i < size)
	{
	    dst[i] = src[j];
	}
	i++;
    }

    if (i < size)
    {
	dst[i] = src[j];
    }
    else
    {
	dst[size-1] = src[j];
    }

    return i;
}

#endif



#ifndef HAVE_STRLCPY


/* From the OpenBSD man page:                                       */
/*                                                                  */
/* The strlcpy() function copies up to size - 1 characters from the */
/* NUL-terminated string src to dst, NUL-terminating the result.    */

size_t strlcpy(char* dst, const char* src, size_t size)
{
    int i;

    assert(size > 0);

    for (i = 0; src[i] != '\0'; i++)
    {
	if (i < size)
	{
	    dst[i] = src[i];
	}
    }

    if (i < size)
    {
	dst[i] = src[i];
    }
    else
    {
	dst[size-1] = src[i];
    }

    return i;
}
#endif



