--
--          This file is part of the New World OS and Objectify projects
--                        Copyright (C) 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, bug and feature
--   request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-08-07 07:42:54 -0600 (Fri, 07 Aug 2009) $
--   $Revision: 4303 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
--
-- This program is a quick hack to output a random line from the lines
-- fed to it via the standard input.  I used it temporarily in the
-- test_remove_file.sh script.
--

class RANDOM_LINE

creation make

feature

   make is
      local
         lines: FIXED_ARRAY[STRING]
         line: STRING
         temp: STRING
         rand: INTEGER
      do
         !!lines.with_capacity(2048)
         !!line.make(1024)

         from
            std_input.read_line_in(line)
         until
            std_input.end_of_input
         loop
            !!temp.copy(line)
            lines.add_last(temp)

            std_input.read_line_in(line)
         end

--         std_output.put_string("Lines: ")
--         std_output.put_integer(lines.count)
--         std_output.put_new_line

         random_number_generator.next
	 rand := random_number_generator.last_integer(lines.lower + 2, lines.upper - 1)

--         std_output.put_string("Rand: ")
--         std_output.put_integer(rand)
--         std_output.put_new_line

         std_output.put_string(lines.item(rand))
	 std_output.put_new_line
      end

end

