--
--          This file is part of the New World OS and Objectify projects
--                  Copyright (C) 2006, 2007, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, bug and feature
--   request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-08-07 07:42:54 -0600 (Fri, 07 Aug 2009) $
--   $Revision: 4303 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--


class CONVERT_CSV_TO_C_STRUCTS

inherit GLOBALS

creation make

feature

   make is
      local
         line: STRING
         i, j: INTEGER
         class_def: CLASS_DEFINITION
	 feature_def: FEATURE_DEFINITION
         name: NAME
         spelling: SPELLING
         type: CLASS_DEFINITION
         verbose: BOOLEAN
      do
         !!line.make(256)

         if argument_count > 0 then
            if argument_count > 1 or else not (argument(1).is_equal("--verbose") or argument(1).is_equal("-v")) then
               std_error.put_string("usage: convert_cvs_to_c_structs [--verbose]%N")
               die_with_code(exit_failure_code)
            end
            verbose := True
         end

       -- Spellings

         csv_file.connect_to("spelling.csv")

         if not csv_file.is_connected then
            std_error.put_string("unable to open: spelling.csv%N")
            die_with_code(exit_failure_code)
         end

         from
            csv_file.read_line_in(line)
         until
            csv_file.end_of_input
         loop
            !!spelling.make_from_csv(line)

            all_spellings.add_last(spelling)

            csv_file.read_line_in(line)
         end

         csv_file.disconnect

         from
            i := all_spellings.lower
         until
            i > all_spellings.upper
         loop
            spelling := all_spellings.item(i)

            if verbose then
               std_output.put_string("Spelling: 0x")
               std_output.put_unsigned_in_hexadecimal(spelling.reference)
               std_output.put_string(" ")
               std_output.put_string(spelling.spelling)
               std_output.put_new_line
            end

            i := i + 1
         end


       -- Names

         csv_file.connect_to("name.csv")

         if not csv_file.is_connected then
            std_error.put_string("unable to open: name.csv%N")
            die_with_code(exit_failure_code)
         end

         from
            csv_file.read_line_in(line)
         until
            csv_file.end_of_input
         loop
            !!name.make_from_csv(line)

            all_names.add_last(name)

            csv_file.read_line_in(line)
         end

         csv_file.disconnect

         from
            i := all_names.lower
         until
            i > all_names.upper
         loop
            name := all_names.item(i)

            if verbose then
               std_output.put_string("Name: 0x")
               std_output.put_unsigned_in_hexadecimal(name.reference)
               std_output.put_string(" ")
               std_output.put_string(name.name)
               std_output.put_new_line
            end

            i := i + 1
         end


       -- Feature_Definitions

         csv_file.connect_to("feature_definition.csv")

         if not csv_file.is_connected then
            std_error.put_string("unable to open: feature_definition.csv%N")
            die_with_code(exit_failure_code)
         end

         from
            csv_file.read_line_in(line)
         until
            csv_file.end_of_input
         loop
            !!feature_def.make_from_csv(line)

            all_features.add_last(feature_def)

            csv_file.read_line_in(line)
         end

         csv_file.disconnect

         from
            i := all_features.lower
         until
            i > all_features.upper
         loop
            feature_def := all_features.item(i)

            if verbose then
               std_output.put_string("Feature: 0x")
               std_output.put_unsigned_in_hexadecimal(feature_def.reference)
               std_output.put_string(" ")
               std_output.put_string(feature_def.name.name)
               std_output.put_string(" ")
               std_output.put_integer(feature_def.number)
               std_output.put_new_line
            end

            i := i + 1
         end


      -- Class defintions

         csv_file.connect_to("class_definition.csv")

         if not csv_file.is_connected then
            std_error.put_string("unable to open: class_definition.csv%N")
            die_with_code(exit_failure_code)
         end

         from
            csv_file.read_line_in(line)
         until
            csv_file.end_of_input
         loop
            !!class_def.make_from_csv(line)

            all_classes.add_last(class_def)

            csv_file.read_line_in(line)
         end

         csv_file.disconnect

         from
            i := all_classes.lower
         until
            i > all_classes.upper
         loop
            class_def := all_classes.item(i)

            if verbose then
               std_output.put_string("Class: 0x")
               std_output.put_unsigned_in_hexadecimal(class_def.reference)
               std_output.put_string(" ")
               std_output.put_string(class_def.name.name)
               std_output.put_new_line
            end

            i := i + 1
         end

       -- Create the c_structs file

         !!out_file.connect_to("c_structs.h")

         if not out_file.is_connected then
            std_error.put_string("unable to open: c_structs.h%N")
            die_with_code(exit_failure_code)
         end

         out_file.put_string("/* This file was generated by the convert_csv_to_c_structs.e program from the  */%N")
         out_file.put_string("/* class_definition.csv, feature_definition.csv, name.csv, and spelling.csv    */%N")
         out_file.put_string("/* files.  You should not make changes to this file.  Any changes should be    */%N")
         out_file.put_string("/* made to the .cvs files and then rerun the convert_csv_to_c_structs program. */%N")
         out_file.put_new_line
         out_file.put_new_line

         from
            i := all_classes.lower
         until
            i > all_classes.upper
         loop
            class_def := all_classes.item(i)

            -- only output classes that have features (built in types don't)

            if class_def.features.count > 0 then
               out_file.put_string("typedef struct {%N")
               out_file.put_string("    EveryObject header;%N")

               from
                  j := class_def.features.lower
               until
                  j > class_def.features.upper
               loop
                  type := find_class_from_reference(class_def.features.item(j).type)

                  if type.name.name.is_equal("object_reference") then
                     out_file.put_string("    ObjRef ")
                  elseif type.name.name.is_equal("byte") then
                     out_file.put_string("    uint8 ")
                  elseif type.name.name.is_equal("character") then
                     out_file.put_string("    char ")
                  elseif type.name.name.is_equal("time_stamp") then
                     out_file.put_string("    TimeStamp ")
                  end

                  out_file.put_string(class_def.features.item(j).name.name)

                  if class_def.features.item(j).number /= 1 then
                     out_file.put_character('[')
                     out_file.put_integer(class_def.features.item(j).number)
                     out_file.put_character(']')
                  end

                  out_file.put_string(";%N")

                  j := j + 1
               end

               out_file.put_string("} C_struct_")
               out_file.put_string(class_def.name.name_capitalized)
               out_file.put_string(";%N%N")
            end

            i := i + 1
         end

         out_file.put_new_line

         out_file.disconnect
      end


   out_file: STD_FILE_WRITE

   csv_file: STD_FILE_READ is
      once
         !!Result.make
      end

end

