#
#          This file is part of the New World OS and Objectify projects
#                     Copyright (C) 2008, 2009  QRW Software
#               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program, in the file LICENSE.  If not, see 
#   <http://www.gnu.org/licenses/>.
#
#   For the latest information, source code (SVN), releases, bug and feature
#   request tracking go to:
#      http://sourceforge.net/projects/objectify
#
#   For older bug tracking, releases and source code (CVS) prior to the
#   Alpha_30 release go to:
#      http://sourceforge.net/projects/nwos
#
#   Other related websites:
#      http://www.qrwsoftware.com
#      http://www.worldwide-database.org
#
#   You can also contact me via paper mail at:
#
#      QRW Software
#      P.O. Box 27511
#      Salt Lake City, UT 84127-0511, USA.
#
#   $Author: jsedwards $
#   $Date: 2009-08-13 06:05:50 -0600 (Thu, 13 Aug 2009) $
#   $Revision: 4325 $
#
#   NOTE: Subversion does not support the Log keyword so I have removed the
#   logs that were here when I was using CVS.  Use the "svn log" command to
#   see the revision history of this file.
#   (See http://subversion.tigris.org/faq.html#log-in-source)
# 



# These are the cases to test (taken from the header of the nwos_create_file function):
#
#         Matching  Matching  Matching  Matching   Data    Allow      Action      Return
#           Path     Assoc      Time      File    Stored  Multiple
#  Case 2:   T         T         X         T        T        X      Do Nothing  FOUND_EXISTING
#  Case 6:   T         T         X         T        F        X      Import Data IMPORTED_DATA

#  Case 7:   T         F         X         T        X        X      Do Nothing  DUPLICATE_FILE

#  Case 4:   F         X         X         T        X        T      Create Path CREATED_NEW_PATH_FOR_EXISTING_FILE
#  Case 3:   F         X         X         T        X        F      Do Nothing  DUPLICATE_FILE

#  Case 5:   T         X         X         F        X        X      Do Nothing  DUPLICATE_PATH
#  Case 1:   F         X         X         F        X        X      Create all  CREATED_NEW

# These are the cases where only the case is different in the file names

#  Case 8:   F         X         X         T        X        T      Create Path CREATED_NEW_PATH_FOR_EXISTING_FILE
#  Case 9:   F         X         X         F        X        T      Create Path CREATED_NEW

# These are the cases to test (taken from the header of the nwos_add_new_revision_of_file function):

#  Case 10:  X         X         X         T        X               Do Nothing  DUPLICATE_FILE
#  Case 11:  F         X         X         F        X               Do Nothing  PATH_NOT_FOUND
#  Case 12:  T         X         X         F        X               Create revision


export OBJECTIFY_TEST_ONLY_DO_NOT_USE="Import Cases Test"
export OBJECTIFY_PRIVATE_PATH=/tmp/objectify_test/private.obj
export OBJECTIFY_LOG_FILE_PATH=/tmp/objectify_test/objectify_log
export OBJECTIFY_BACKUP_PATH=/tmp/objectify_test

EXEC=$PWD

if ! rm -fr /tmp/objectify_test; then
   echo ""
   echo "could not remove /tmp/objectify_test directory"
   echo ""
   exit 1
fi

if ! rm -fr /tmp/test; then
   echo ""
   echo "could not remove /tmp/objectify_test directory"
   echo ""
   exit 1
fi

mkdir /tmp/test
cd /tmp/test

echo "------------------"
echo " prep..."
echo "------------------"

echo $OBJECTIFY_PRIVATE_PATH

if ! $EXEC/src/apps/util/prep_disk; then
   echo ""
   echo "prep_disk failed"
   echo ""
   exit 1
fi

sleep 1

echo "------------------------------------------------------------------"
echo " test that programs fail when there are no files in the system..."
echo "------------------------------------------------------------------"

if $EXEC/src/apps/file/import_file test1.txt; then
   echo ""
   echo "import non-existant file succeeded"
   echo ""
   exit 1
fi

if $EXEC/src/apps/file/verify_file test1.txt; then
   echo ""
   echo "verify non-existant file succeeded"
   echo ""
   exit 1
fi

if $EXEC/src/apps/file/export_file test1.txt; then
   echo ""
   echo "export non-existant file succeeded"
   echo ""
   exit 1
fi

if $EXEC/src/apps/file/list_files test1.txt; then
   echo ""
   echo "list non-existant file succeeded"
   echo ""
   exit 1
fi


echo "-------------------------"
echo " Case 1: import new file"
echo "-------------------------"

echo "This is test #1" >> test1.txt

if ! $EXEC/src/apps/file/import_file test1.txt > /tmp/test1.out; then
   echo ""
   echo "import_file failed"
   echo ""
   exit 1
fi

if ! grep -q "files created:   1" /tmp/test1.out; then
   echo ""
   echo "did not create 1 file"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/list_files --md5 test1.txt > test1.md5; then
   echo ""
   echo "list_files --md5 failed"
   echo ""
   exit 1
fi

if ! md5sum -c test1.md5; then
   echo ""
   echo "MD5 sum does not match"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/list_files --sha1 test1.txt > test1.sha1; then
   echo ""
   echo "list_files --sha1 failed"
   echo ""
   exit 1
fi

if ! sha1sum -c test1.sha1; then
   echo ""
   echo "SHA1 sum does not match"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/list_files --sha256 test1.txt > test1.sha256; then
   echo ""
   echo "list_files --sha256 failed"
   echo ""
   exit 1
fi

if ! sha256sum -c test1.sha256; then
   echo ""
   echo "SHA256 sum does not match"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/list_files --sha512 test1.txt > test1.sha512; then
   echo ""
   echo "list_files --sha512 failed"
   echo ""
   exit 1
fi

if ! sha512sum -c test1.sha512; then
   echo ""
   echo "SHA512 sum does not match"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/verify_file test1.txt; then
   echo ""
   echo "verify_file failed"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/verify_file --remove-no-shred test1.txt; then
   echo ""
   echo "verify_file failed"
   echo ""
   exit 1
fi

if $EXEC/src/apps/file/verify_file test1.txt; then
   echo ""
   echo "verify non-existant file succeeded"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/export_file test1.txt; then
   echo ""
   echo "export_file failed"
   echo ""
   exit 1
fi

if ! md5sum -c test1.md5; then
   echo ""
   echo "MD5 sum does not match"
   echo ""
   exit 1
fi

if ! sha1sum -c test1.sha1; then
   echo ""
   echo "SHA1 sum does not match"
   echo ""
   exit 1
fi

if ! sha256sum -c test1.sha256; then
   echo ""
   echo "SHA256 sum does not match"
   echo ""
   exit 1
fi

if ! sha512sum -c test1.sha512; then
   echo ""
   echo "SHA512 sum does not match"
   echo ""
   exit 1
fi

echo "------------------------------"
echo " Case 2: file already exists"
echo "------------------------------"

sleep 1

if ! touch test1.txt; then
   echo ""
   echo "touch failed"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/import_file test1.txt > /tmp/test1.out; then
   echo ""
   echo "import_file failed"
   echo ""
   exit 1
fi

if ! grep -q "existing files:  1" /tmp/test1.out; then
   echo ""
   echo "did not find existing file"
   echo ""
   exit 1
fi

if $EXEC/src/apps/file/verify_file test1.txt; then
   echo ""
   echo "verify file with different time stamp succeeded"
   echo ""
   exit 1
fi

if $EXEC/src/apps/file/verify_file --remove-no-shred test1.txt; then
   echo ""
   echo "verify file --remove with different time stamp succeeded"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/verify_file --ignore-time test1.txt; then
   echo ""
   echo "verify file with --ignore-time failed"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/verify_file --ignore-time --remove-no-shred test1.txt; then
   echo ""
   echo "verify file --remove --ignore-time failed"
   echo ""
   exit 1
fi



echo "-----------------------------------------------------------"
echo " test that programs fail when file isn't in the system..."
echo "-----------------------------------------------------------"

if $EXEC/src/apps/file/import_file test2.txt; then
   echo ""
   echo "import non-existant file succeeded"
   echo ""
   exit 1
fi

if $EXEC/src/apps/file/verify_file test2.txt; then
   echo ""
   echo "verify non-existant file succeeded"
   echo ""
   exit 1
fi

if $EXEC/src/apps/file/export_file test2.txt; then
   echo ""
   echo "export non-existant file succeeded"
   echo ""
   exit 1
fi

if $EXEC/src/apps/file/list_files test2.txt; then
   echo ""
   echo "list non-existant file succeeded"
   echo ""
   exit 1
fi


echo "---------------------------------------------------"
echo " Case 3: import duplicate file, different name..."
echo "---------------------------------------------------"

echo "This is test #1" >> test1diffname.txt

if $EXEC/src/apps/file/import_file test1diffname.txt > /tmp/test1.out; then
   echo ""
   echo "import duplicate file succeeded"
   echo ""
   exit 1
fi

if ! grep -q "duplicate files: 1" /tmp/test1.out; then
   echo ""
   echo "did not report 1 duplicate file"
   echo ""
   exit 1
fi


echo "-----------------------------------------------------"
echo " Case 4: import duplicate file in a subdirectory..."
echo "-----------------------------------------------------"

mkdir subdir

mv -i test1diffname.txt subdir

if ! $EXEC/src/apps/file/import_file -r subdir > /tmp/test1.out; then
   echo ""
   echo "import_file subdir failed"
   echo ""
   exit 1
fi

if ! grep -q "new paths:       1" /tmp/test1.out; then
   echo ""
   echo "did not create 1 file"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/verify_file -r subdir; then
   echo ""
   echo "verify_file subdir failed"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/verify_file --remove-no-shred -r subdir; then
   echo ""
   echo "verify_file --remove subdir failed"
   echo ""
   exit 1
fi

if $EXEC/src/apps/file/verify_file subdir; then
   echo ""
   echo "verify non-existant file succeeded"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/export_file subdir/*; then
   echo ""
   echo "export_file failed"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/import_file subdir/* > /tmp/test1.out; then
   echo ""
   echo "import_file failed"
   echo ""
   exit 1
fi

if ! grep -q "existing files:  1" /tmp/test1.out; then
   echo ""
   echo "did not find existing file"
   echo ""
   exit 1
fi


echo "-------------------------------------------------"
echo " Case 5: file has changed (path is the same)..."
echo "-------------------------------------------------"

echo "Test #1, has been changed" >> test1.txt

if $EXEC/src/apps/file/verify_file test1.txt; then
   echo ""
   echo "verify_file revised file succeeded"
   echo ""
   exit 1
fi

if $EXEC/src/apps/file/verify_file --remove-no-shred test1.txt; then
   echo ""
   echo "verify_file --remove revised file succeeded"
   echo ""
   exit 1
fi

if $EXEC/src/apps/file/import_file test1.txt > /tmp/test1r.out; then
   echo ""
   echo "import_file revised file without --add-revision succeeded"
   echo ""
   exit 1
fi

if ! grep -q "duplicate paths: 1" /tmp/test1r.out; then
   echo ""
   echo "did not report 1 duplicate path"
   echo ""
   exit 1
fi


echo "---------------------------"
echo " Case 6: import data..."
echo "---------------------------"

mkdir 20081221-909
echo "Testing import data" >> 20081221-909/test2.txt

if ! $EXEC/src/apps/file/disc_list 20081221-909 <<EOF ; then
20081221-909
EOF
   echo ""
   echo "disc_list failed"
   echo ""
   exit 1
fi

if $EXEC/src/apps/file/export_file test2.txt; then
   echo ""
   echo "export file with no data succeeded"
   echo ""
   exit 1
fi

mv -i 20081221-909/test2.txt .
rmdir 20081221-909

if ! $EXEC/src/apps/file/list_files --md5 test2.txt > test2.md5; then
   echo ""
   echo "list_files --md5 failed"
   echo ""
   exit 1
fi

if ! md5sum -c test2.md5; then
   echo ""
   echo "MD5 sum does not match"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/list_files --sha1 test2.txt > test2.sha1; then
   echo ""
   echo "list_files --sha1 failed"
   echo ""
   exit 1
fi

if ! sha1sum -c test2.sha1; then
   echo ""
   echo "SHA1 sum does not match"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/list_files --sha256 test2.txt > test2.sha256; then
   echo ""
   echo "list_files --sha256 failed"
   echo ""
   exit 1
fi

if ! sha256sum -c test2.sha256; then
   echo ""
   echo "SHA256 sum does not match"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/list_files --sha512 test2.txt > test2.sha512; then
   echo ""
   echo "list_files --sha512 failed"
   echo ""
   exit 1
fi

if ! sha512sum -c test2.sha512; then
   echo ""
   echo "SHA512 sum does not match"
   echo ""
   exit 1
fi


if ! $EXEC/src/apps/file/verify_file test2.txt; then
   echo ""
   echo "verify_file failed"
   echo ""
   exit 1
fi

if $EXEC/src/apps/file/verify_file --remove-no-shred test2.txt; then
   echo ""
   echo "verify_file --remove no data succeeded"
   echo ""
   exit 1
fi


if ! $EXEC/src/apps/file/import_file test2.txt > /tmp/test2i.out; then
   echo ""
   echo "import_file data failed"
   echo ""
   exit 1
fi

if ! grep -q "imported data:   1" /tmp/test2i.out; then
   echo ""
   echo "did not report imported data for 1 file"
   echo ""
   exit 1
fi


if ! $EXEC/src/apps/file/verify_file test2.txt; then
   echo ""
   echo "verify_file failed"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/verify_file --remove-no-shred test2.txt; then
   echo ""
   echo "verify_file --remove failed"
   echo ""
   exit 1
fi


if ! $EXEC/src/apps/file/export_file test2.txt; then
   echo ""
   echo "export file failed"
   echo ""
   exit 1
fi

if ! md5sum -c test2.md5; then
   echo ""
   echo "MD5 sum does not match"
   echo ""
   exit 1
fi

if ! sha1sum -c test2.sha1; then
   echo ""
   echo "SHA1 sum does not match"
   echo ""
   exit 1
fi

if ! sha256sum -c test2.sha256; then
   echo ""
   echo "SHA256 sum does not match"
   echo ""
   exit 1
fi

if ! sha512sum -c test2.sha512; then
   echo ""
   echo "SHA512 sum does not match"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/verify_file --remove-min-shred test2.txt; then
   echo ""
   echo "verify_file --remove-min-shred failed"
   echo ""
   exit 1
fi



echo "--------------------------------------"
echo " Case 7: file and path both exist..."
echo "--------------------------------------"

echo "This is test #1" >> test2.txt

if $EXEC/src/apps/file/import_file test2.txt > /tmp/test2e.out; then
   echo ""
   echo "import_file path and file exist succeeded"
   echo ""
   exit 1
fi

if ! grep -q "duplicate files: 1" /tmp/test2e.out; then
   echo ""
   echo "did not report 1 duplicate file"
   echo ""
   exit 1
fi


if $EXEC/src/apps/file/import_file -r test2.txt > /tmp/test2e.out; then
   echo ""
   echo "import_file -r path and file exist succeeded"
   echo ""
   exit 1
fi

if ! grep -q "duplicate files: 1" /tmp/test2e.out; then
   echo ""
   echo "did not report 1 duplicate file"
   echo ""
   exit 1
fi


echo "--------------------------------------"
echo " Case 8: files differ only in case..."
echo "--------------------------------------"

echo "This is test #8" >> test8.txt

if ! $EXEC/src/apps/file/import_file test8.txt > /tmp/test8.out; then
   echo ""
   echo "import_file test8.txt failed"
   echo ""
   exit 1
fi

sleep 1

cp test8.txt Test8.txt

if $EXEC/src/apps/file/import_file Test8.txt > /tmp/test8.out; then
   echo ""
   echo "import_file Test8.txt succeeded"
   echo ""
   exit 1
fi

if ! grep -q "duplicate files: 1" /tmp/test8.out; then
   echo ""
   echo "did not report 1 duplicate file"
   echo ""
   exit 1
fi


if ! $EXEC/src/apps/file/import_file -r Test8.txt > /tmp/test8.out; then
   echo ""
   echo "import_file -r Test8.txt failed"
   echo ""
   exit 1
fi

if ! grep -q "new paths:       1" /tmp/test8.out; then
   echo ""
   echo "did not report 1 new path file"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/list_files --md5 ?est8.txt > test8.md5; then
   echo ""
   echo "list_files --md5 failed"
   echo ""
   exit 1
fi

if ! md5sum -c test8.md5; then
   echo ""
   echo "MD5 sum does not match"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/list_files --sha1 ?est8.txt > test8.sha1; then
   echo ""
   echo "list_files --sha1 failed"
   echo ""
   exit 1
fi

if ! sha1sum -c test8.sha1; then
   echo ""
   echo "SHA1 sum does not match"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/list_files --sha256 ?est8.txt > test8.sha256; then
   echo ""
   echo "list_files --sha256 failed"
   echo ""
   exit 1
fi

if ! sha256sum -c test8.sha256; then
   echo ""
   echo "SHA256 sum does not match"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/list_files --sha512 ?est8.txt > test8.sha512; then
   echo ""
   echo "list_files --sha512 failed"
   echo ""
   exit 1
fi

if ! sha512sum -c test8.sha512; then
   echo ""
   echo "SHA512 sum does not match"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/verify_file ?est8.txt; then
   echo ""
   echo "verify_file failed"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/verify_file --remove-no-shred ?est8.txt; then
   echo ""
   echo "verify_file failed"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/export_file ?est8.txt; then
   echo ""
   echo "export_file failed"
   echo ""
   exit 1
fi

if ! md5sum -c test8.md5; then
   echo ""
   echo "MD5 sum does not match"
   echo ""
   exit 1
fi

if ! sha1sum -c test8.sha1; then
   echo ""
   echo "SHA1 sum does not match"
   echo ""
   exit 1
fi

if ! sha256sum -c test8.sha256; then
   echo ""
   echo "SHA256 sum does not match"
   echo ""
   exit 1
fi

if ! sha512sum -c test8.sha512; then
   echo ""
   echo "SHA512 sum does not match"
   echo ""
   exit 1
fi


echo "--------------------------------------"
echo " Case 9: files differ only in case..."
echo "--------------------------------------"

echo "This is test #9" >> test9.txt
echo "This is Test #9" >> Test9.txt

if ! $EXEC/src/apps/file/import_file test9.txt Test9.txt > /tmp/test9.out; then
   echo ""
   echo "import_file test9.txt failed"
   echo ""
   exit 1
fi

if ! grep -q "files created:   2" /tmp/test9.out; then
   echo ""
   echo "did not create 2 files"
   echo ""
   exit 1
fi


if ! $EXEC/src/apps/file/list_files --md5 ?est9.txt > test9.md5; then
   echo ""
   echo "list_files --md5 failed"
   echo ""
   exit 1
fi

if ! md5sum -c test9.md5; then
   echo ""
   echo "MD5 sum does not match"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/list_files --sha1 ?est9.txt > test9.sha1; then
   echo ""
   echo "list_files --sha1 failed"
   echo ""
   exit 1
fi

if ! sha1sum -c test9.sha1; then
   echo ""
   echo "SHA1 sum does not match"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/list_files --sha256 ?est9.txt > test9.sha256; then
   echo ""
   echo "list_files --sha256 failed"
   echo ""
   exit 1
fi

if ! sha256sum -c test9.sha256; then
   echo ""
   echo "SHA256 sum does not match"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/list_files --sha512 ?est9.txt > test9.sha512; then
   echo ""
   echo "list_files --sha512 failed"
   echo ""
   exit 1
fi

if ! sha512sum -c test9.sha512; then
   echo ""
   echo "SHA512 sum does not match"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/verify_file ?est9.txt; then
   echo ""
   echo "verify_file failed"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/verify_file --remove-no-shred ?est9.txt; then
   echo ""
   echo "verify_file failed"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/export_file ?est9.txt; then
   echo ""
   echo "export_file failed"
   echo ""
   exit 1
fi

if ! md5sum -c test9.md5; then
   echo ""
   echo "MD5 sum does not match"
   echo ""
   exit 1
fi

if ! sha1sum -c test9.sha1; then
   echo ""
   echo "SHA1 sum does not match"
   echo ""
   exit 1
fi

if ! sha256sum -c test9.sha256; then
   echo ""
   echo "SHA256 sum does not match"
   echo ""
   exit 1
fi

if ! sha512sum -c test9.sha512; then
   echo ""
   echo "SHA512 sum does not match"
   echo ""
   exit 1
fi


echo "--------------------------------------------------"
echo " Case 10: add revision but file already exists..."
echo "--------------------------------------------------"

echo "This is test #1" > test2.txt

if $EXEC/src/apps/file/import_file --add-revision test2.txt > /tmp/test8r.out; then
   echo ""
   echo "import_file --add-revision new file succeeded"
   echo ""
   exit 1
fi

if ! grep -q "duplicate files: 1" /tmp/test8r.out; then
   echo ""
   echo "did not report 1 duplicate file"
   echo ""
   exit 1
fi


echo "This is test #1" > test3.txt

if $EXEC/src/apps/file/import_file --add-revision test2.txt > /tmp/test8r.out; then
   echo ""
   echo "import_file --add-revision new file succeeded"
   echo ""
   exit 1
fi

if ! grep -q "duplicate files: 1" /tmp/test8r.out; then
   echo ""
   echo "did not report 1 duplicate file"
   echo ""
   exit 1
fi


echo "-------------------------------------------------"
echo " Case 11: add revision but path doesn't exist..."
echo "-------------------------------------------------"

echo "This is test #3" > test3.txt

if $EXEC/src/apps/file/import_file --add-revision test3.txt > /tmp/test3r.out; then
   echo ""
   echo "import_file --add-revision new file succeeded"
   echo ""
   exit 1
fi

if ! grep -q "path not found:  1" /tmp/test3r.out; then
   echo ""
   echo "did not report 1 path not found file"
   echo ""
   exit 1
fi


echo "---------------------------"
echo " Case 12: revised file..."
echo "---------------------------"

if ! $EXEC/src/apps/file/import_file --add-revision test1.txt > /tmp/test1r.out; then
   echo ""
   echo "import_file --add-revision failed"
   echo ""
   exit 1
fi

if ! grep -q "new revisions:   1" /tmp/test1r.out; then
   echo ""
   echo "did not report 1 new revision"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/verify_file test1.txt; then
   echo ""
   echo "verify_file revised file failed"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/verify_file --remove-no-shred test1.txt; then
   echo ""
   echo "verify_file --remove revised file failed"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/export_file test1.txt; then
   echo ""
   echo "export_file failed"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/verify_file test1.txt; then
   echo ""
   echo "verify_file revised file failed"
   echo ""
   exit 1
fi

if ! $EXEC/src/apps/file/verify_file --remove-no-shred test1.txt; then
   echo ""
   echo "verify_file --remove revised file failed"
   echo ""
   exit 1
fi


echo ""
echo "All tests passed!"
echo ""

exit 0

