--
--          This file is part of the New World OS and Objectify projects
--                  Copyright (C) 2006, 2007, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, bug and feature
--   request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-07-25 17:25:15 -0600 (Sat, 25 Jul 2009) $
--   $Revision: 4184 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.  I have kept the portion of the
--   old CVS log before this file was moved from the main directory.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
--
-- Revision 1.2  2006/11/11 12:29:19  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.1  2006/02/26 15:46:10  jsedwards
-- Incomplete version, not used.
--

class NWOS_THING

-- This class represents an abstract "thing" such as a word or a car.
-- It represents that "thing" in any language.

inherit NWOS_OBJECT

feature

   names: ARRAY[NWOS_NOUN] is
      do
         load_if_not_already
         Result := names_obj
      ensure
         Result /= Void
      end

   add_name(noun: NWOS_NOUN) is
      do
         names.add_last(noun)
      end


feature {NONE}

   write_names_to_stream(stream: BINARY_OUTPUT_STREAM) is
      local
         i: INTEGER
      do
         from
            i := names_obj.lower
         variant
            names_obj.upper - i
         until
            i > names_obj.upper
         loop
            names_obj.item(i).class_definition.identifier.write_to_stream(stream)
            names_obj.item(i).identifier.write_to_stream(stream)
            i := i + 1
         end
      end

   read_names_from_stream(stream: BINARY_INPUT_STREAM): NWOS_REFERENCE is
      local
         noun: NWOS_NOUN
         object_ref: NWOS_REFERENCE
      do
         !!names_obj.with_capacity(4, 1)

         from
            !!Result.make_from_stream(stream)
         until
            not Result.is_equal(Class_noun_ref)
         loop
            !!object_ref.make_from_stream(stream)

            noun ?= object_ref.get_object(Result)

            check
               noun /= Void
            end

            names_obj.add_last(noun)

            !!Result.make_from_stream(stream)
         end
      end


feature {NONE}

   names_obj: like names


end

