/*
--          This file is part of the New World OS and Objectify projects
--                  Copyright (C) 2006, 2007, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, bug and feature
--   request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-07-25 17:25:15 -0600 (Sat, 25 Jul 2009) $
--   $Revision: 4184 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.  I have kept the portion of the
--   old CVS log before this file was moved from the main directory.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
--
-- Revision 1.5  2006/11/11 12:01:02  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.4  2006/04/08 14:01:04  jsedwards
-- Complete overhaul to build the new format (0011) binary codes.
--
-- Revision 1.3  2006/01/22 16:58:07  jsedwards
-- Fixed so only lower 128 binary codes reference the ascii character set.
--
-- Revision 1.2  2006/01/22 15:12:59  jsedwards
-- Changed for new binary codes object (that has the reference list inlined).
--
-- Revision 1.1  2006/01/18 13:22:13  jsedwards
-- Run once app to create the binary code objects and their reference lists.
--
*/

#include <assert.h>
#include <stdio.h>
#include <string.h>   /* define memset */
#include <stdlib.h>

#include "predefined_references.h"

char* create_binary_codes_revision = "$Revision: 4184 $";


static void gen_one_byte_code_ref(uint8 code, reference ref)
{
    int i;
    for (i = 0; i < sizeof(reference); i++) ref[i] = 0;
    ref[0] = DOMAIN_BINARY_CODES + 1;
    ref[1] = code;
}


/*---------------------------------------------------------------------------------------------------------------------------
  instance of binary code:

    definition attribute:     binary code
    creation attribute:       log
    number of bits attribute: cardinal 8
    binary_bits attribute:    xx
    reference attribute:      list of references - pointer to a list of instances for various types (character codes, etc.)
---------------------------------------------------------------------------------------------------------------------------*/

int main()
{
    reference binary_code_ref;
    reference binary_bits;
    char path[NWOS_PATH_MAX];
    int i;
    FILE* fp;

    printf("Creating 256 binary code objects...\n");

    memset(binary_bits, 0, sizeof(reference));

    for (i = 0; i < 256; i++)
    {
	gen_one_byte_code_ref(i, binary_code_ref);   /* create the reference */

	nwos_ref_to_path(binary_code_ref, path);

	fp = fopen(path, "wb");

	if (fp == NULL)
	{
	    perror(path);
	    exit(1);
	}

	write_file_header(binary_code_ref, fp);

	write_pair(Ref_attr_definition,  Ref_def_binary_code, fp);

	write_pair(Ref_attr_creation,    Ref_create_eight_bit_binary_codes, fp);

	write_pair(Ref_attr_num_of_bits, Ref_cardinal_8, fp);

	binary_bits[0] = i;
	write_pair(Ref_attr_binary_bits, binary_bits, fp);

	/* Let's go with having the character codes stored within this object instead of a separate list for now */
	/*	write_pair(Ref_attr_char_code_list, Ref_char_code_list??, fp); */

	if (fclose(fp) != 0)
	{
	    perror(path);
	    exit(1);
	}
    }

    printf("Done!\n");

    return 0;
}

