/*
--          This file is part of the New World OS and Objectify projects
--            Copyright (C) 2004, 2005, 2006, 2007, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, bug and feature
--   request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-07-25 17:25:15 -0600 (Sat, 25 Jul 2009) $
--   $Revision: 4184 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.  Since this file was originally
--   copied from the file in the root directory I have left the CVS log from
--   that file below.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
--
-- Revision 1.25  2006/11/11 15:24:02  jsedwards
-- Added external declaration for nwos_log function.
--
-- Revision 1.24  2006/11/11 14:18:06  jsedwards
-- Added external declarations for nwos_malloc and nwos_free functions.
--
-- Revision 1.23  2006/11/11 13:57:25  jsedwards
-- Add external declaration for generate_new_public_id function.
--
-- Revision 1.22  2006/11/11 13:34:57  jsedwards
-- Added external declaration of next_public_ref.
--
-- Revision 1.21  2006/11/11 12:01:05  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.20  2006/11/10 13:32:05  jsedwards
-- Moved Ref_List_First_Block and Ref_List_Extra_Block definitions from
-- objectify.c to objectify_private.h so that import_public_csv can use
-- them also.
--
-- Revision 1.19  2006/11/10 04:11:54  jsedwards
-- Add "write_public_object_to_disk" external declaration.
--
-- Revision 1.18  2006/10/26 01:35:58  jsedwards
-- Replaced main trunk version (1.17) with latest version from alpha_05_branch.
--
-- Revision 1.14.2.15  2006/10/22 13:09:30  jsedwards
-- Removed RESERVED_PUBLIC_BLOCKS and PRIVATE_BLOCKS_ON_DISK defines, they
-- are both now variables based upon values read from disk.
--
-- Revision 1.14.2.14  2006/10/11 13:26:28  jsedwards
-- Added bit_map_block_mask definition.
--
-- Revision 1.14.2.13  2006/10/10 07:32:36  jsedwards
-- Move bit map defines to objectify_private.h instead of spread all over.
--
-- Revision 1.14.2.12  2006/10/06 04:35:48  jsedwards
-- Renamed and rearranged the definitions of public and private, blocks and
-- ids.
--
-- Revision 1.14.2.11  2006/10/05 12:47:21  jsedwards
-- Added definitions for number of private blocks (id's) and number of
-- private blocks on the disk.
--
-- Revision 1.14.2.10  2006/09/27 13:25:13  jsedwards
-- Added reference for nwos_block_used function.
--
-- Revision 1.14.2.9  2006/09/26 13:15:35  jsedwards
-- Fixed the number of public reserved blocks (256 MB instead of 128 MB).
--
-- Revision 1.14.2.8  2006/09/26 13:00:53  jsedwards
-- Moved DEFAULT_FILE definition to config.h and added RESERVED_PUBLIC_BLOCKS
-- definition.
--
-- Revision 1.14.2.7  2006/09/18 01:36:26  jsedwards
-- Add declarations and definitions so that file.c can access block read and
-- write encryption routines directly.
--
-- Revision 1.14.2.6  2006/09/16 14:23:53  jsedwards
-- Add declaration of create_reference_list_with_existing_id.
--
-- Revision 1.14.2.5  2006/09/06 13:15:25  jsedwards
-- Removed nwos_seed_sequence function and instead pass pointers to the values
-- in the call to next_sequence function.
--
-- Revision 1.14.2.4  2006/09/03 13:54:55  jsedwards
-- Moved definition of DEFAULT_FILE here from objectify.c so the big_bang can
-- use it to create the file.
--
-- Revision 1.14.2.3  2006/09/03 11:03:24  jsedwards
-- Added declaration of overwrite function.
--
-- Revision 1.14.2.2  2006/09/02 01:09:51  jsedwards
-- Add "ref" parameter to fill_in_common_header so it can put it in header.
--
-- Revision 1.14.2.1  2006/08/18 12:55:57  jsedwards
-- Added new setup_file() routine for creating file and file path classes.
--
-- Revision 1.14  2006/01/12 02:58:28  jsedwards
-- Added external declaration of "update spelling from 0004 to 0005" routine.
--
-- Revision 1.13  2006/01/09 03:26:10  jsedwards
-- Added external reference for "upgrade persons from 0004 to 0005" routine.
--
-- Revision 1.12  2006/01/06 14:14:42  jsedwards
-- Removed external declaration of "create all fifty states".  Added external
-- declarations for "setup address", "upgrade states from 0004 to 0005", and
-- "upgrade months from 0004 to 0005".
--
-- Revision 1.11  2006/01/01 21:49:01  jsedwards
-- Moved date, phone, us_state, and word class creations out of "big bang"
-- and into the respective files.
--
-- Revision 1.10  2005/12/31 17:56:23  jsedwards
-- Added declrations for "create_class_definition" and "setup_person" routines.
--
-- Revision 1.9  2005/12/28 13:04:08  jsedwards
-- Added declarations for sequence generator routines in security.c.
--
-- Revision 1.8  2005/12/27 19:47:23  jsedwards
-- Added declaration for create root object routine.
--
-- Revision 1.7  2005/12/27 18:09:27  jsedwards
-- Changed parameters to "fill_in_common_header" and "create_english_language"
-- routines.  Added external references for two global variables: "class_
-- definition_class_ref" and "reference_list_class_ref".  Also added external
-- declarations for "set_spelling_class_ref", "set_name_class_ref", and
-- "remove_object" routines.
--
-- Revision 1.6  2005/12/21 17:10:31  jsedwards
-- Add 'nwos' to 'create_all_area_codes' routine name.
--
-- Revision 1.5  2005/12/21 17:07:36  jsedwards
-- Add declaration of create_all_area_codes.
--
-- Revision 1.4  2005/12/21 04:01:12  jsedwards
-- Added declarations for creating all states and all months.
--
-- Revision 1.3  2005/12/11 16:48:13  jsedwards
-- Added "create_english_language" declaration.
--
-- Revision 1.2  2005/12/10 15:03:36  jsedwards
-- Fixed header to say the GPL is in the LICENSE file instead of COPYING.
--
-- Revision 1.1  2005/11/26 15:19:24  jsedwards
-- External references that are private to the system (shouldn't be used by
-- 'user' programs).
--
*/

#ifndef OBJECTIFY_PRIVATE_H
#define OBJECTIFY_PRIVATE_H

#include "objectify.h"

#define NUM_PUBLIC_IDS 268435456

#define NUM_PRIVATE_IDS ((uint32) (4294967296LL - NUM_PUBLIC_IDS))


#define BIT_MAP_BLOCKS 32
#define BIT_MAP_BYTES (BIT_MAP_BLOCKS * FILE_BLOCK_SIZE)

#define BLOCKS_IN_CHUNK (BIT_MAP_BYTES * 8)
#define BIT_MAP_BLOCK_MASK (~(BLOCKS_IN_CHUNK-1))

#define CHUNK_SIZE (BLOCKS_IN_CHUNK * FILE_BLOCK_SIZE)

#define IVEC_SIZE 8  /* don't know for sure, the man page doesn't say, i made the buffer larger and looked at if afterwards. */

#define NUM_STORED_SEQ 4096     /* number of sequence tables that are stored, 4096 = 1 MB worth and uses 1 MB worth of RAM */



#define MAX_REFS_IN_REF_LIST (((FILE_BLOCK_SIZE - sizeof(CommonHeader)) / sizeof(ObjRef)) - 1)
#define MAX_REFS_IN_SIDECAR  (((FILE_BLOCK_SIZE - 12) / sizeof(ObjRef)) - 1)

typedef struct ref_list_extra_block {
    struct ref_list_extra_block* next_block_ptr;
    int dirty;
    ObjRef id;
    uint8 checksum[4];
    ObjRef refs[MAX_REFS_IN_SIDECAR];
    ObjRef next_block_ref;
} Ref_List_Extra_Block;

typedef struct {
    struct ref_list_extra_block* next_block_ptr;
    ReferenceList list;
    ObjRef refs[MAX_REFS_IN_REF_LIST];
    ObjRef next_block_ref;
} Ref_List_First_Block;



extern uint8 nwos_random_sequence[NUM_STORED_SEQ][FILE_BLOCK_SIZE];     /* resequencing tables */

extern ObjRef nwos_class_definition_class_ref;
extern ObjRef nwos_reference_list_class_ref;
extern ObjRef nwos_next_public_ref;


extern void nwos_create_class_definition(char* name_of_class);

extern void nwos_setup_address();
extern void nwos_setup_date();
extern void nwos_setup_file();
extern void nwos_setup_person();
extern void nwos_setup_phone();
extern void nwos_setup_us_states();
extern void nwos_setup_word();

extern void nwos_log(char* str);

extern void* nwos_malloc(size_t size);
extern void  nwos_free(void* ptr);

extern void nwos_fill_in_common_header(CommonHeader* common, ObjRef* ref, ObjRef* class_definition_ref);
extern bool nwos_object_exists(ObjRef* ref);
extern void nwos_generate_new_public_id(ObjRef* ref);
extern bool nwos_block_used(ObjRef* ref);
extern void nwos_write_object_to_disk(ObjRef* ref, void* object, size_t size);
extern void nwos_write_public_object_to_disk(ObjRef* ref, void* object, size_t size);
extern void nwos_overwrite_object_to_disk(ObjRef* ref, void* object, size_t size);
extern void nwos_read_object_from_disk(ObjRef* ref, void* object, size_t size);
extern void nwos_create_english_language(ObjRef* ref);
extern void nwos_create_all_twelve_months();
extern void nwos_create_all_area_codes();
extern void nwos_set_spelling_class_ref(ObjRef* spelling_class_ref);
extern void nwos_set_name_class_ref(ObjRef* name_class_ref);
extern bool nwos_create_root(ObjRef* ref);
extern void nwos_remove_object(ObjRef* ref);
extern void nwos_create_reference_list_with_existing_id(ObjRef* for_obj, ObjRef* ref_list);
extern void nwos_flush_dirty_ref_lists();

extern uint32 nwos_next_sequence(uint32* linear_seed, uint32* serial_seed);

extern void nwos_upgrade_spellings_from_0004_to_0005();
extern void nwos_upgrade_months_from_0004_to_0005();
extern void nwos_upgrade_states_from_0004_to_0005();
extern void nwos_upgrade_persons_from_0004_to_0005();
extern void nwos_read_object_from_disk_and_decrypt(ObjRef* ref, void* object, size_t size, uint8 ivec[IVEC_SIZE], uint8 seq_table[FILE_BLOCK_SIZE]);
extern void nwos_write_object_to_disk_and_encrypt(ObjRef* ref, void* object, size_t size, uint8 ivec[IVEC_SIZE], uint8 seq_table[FILE_BLOCK_SIZE]);

#endif

