/*
--          This file is part of the New World OS and Objectify projects
--            Copyright (C) 2004, 2005, 2006, 2007, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, bug and feature
--   request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-07-25 17:25:15 -0600 (Sat, 25 Jul 2009) $
--   $Revision: 4184 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.  Since this file was originally
--   copied from the file in the root directory I have left the CVS log from
--   that file below.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
--
-- Revision 1.6  2006/12/01 14:37:23  jsedwards
-- Fix the year in the copyright.
--
-- Revision 1.5  2006/11/11 12:01:02  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.4  2005/12/10 15:03:35  jsedwards
-- Fixed header to say the GPL is in the LICENSE file instead of COPYING.
--
-- Revision 1.3  2005/11/26 15:00:21  jsedwards
-- Removed "types" includes and just include crc32.h.
--
-- Revision 1.2  2005/11/25 13:27:25  jsedwards
-- Changed names to include "nwos" prefix.
--
-- Revision 1.1.1.1  2005/11/25 12:44:27  jsedwards
-- Copied from 'lab'.
--
-- Revision 1.4  2005/11/23 20:25:04  jsedwards
-- Changed add routine to static (not global) and 'length' parameter to
-- size_t type.
--
-- Revision 1.3  2004/11/03 14:27:17  jsedwards
-- Changed to always be non-partisan for endianess.  The result is always
--   big endian.
--
-- Revision 1.2  2004/11/03 13:27:05  jsedwards
-- Add 'crc32_add' routine.
--
-- Revision 1.1  2004/11/02 14:15:19  jsedwards
-- Initial version with table generation.
--
--
*/

#include "crc32.h"


#define POLYNOMIAL 0xEDB88320;
static uint8 table[256][4];


void nwos_crc32_initialize()
{
    int i, j;
    uint32 crc;

    for (i = 0; i < 256; i++) {
	crc = i;
      
	for(j = 0; j < 8; j++) {

            if ((crc & 1) != 0) {
                  crc = (crc >> 1) ^ POLYNOMIAL;
	    }
            else {
                  crc = (crc >> 1);
	    }
	}
      
	table[i][0] = (uint8) ((crc >> 24) & 0xFF);
	table[i][1] = (uint8) ((crc >> 16) & 0xFF);
	table[i][2] = (uint8) ((crc >>  8) & 0xFF);
	table[i][3] = (uint8) ((crc      ) & 0xFF);
    }
}


static void crc32_add(uint8 byte, uint8 crc32[4])
{
    int index = (int) (byte ^ crc32[3]);
    crc32[3] = crc32[2] ^ table[index][3];
    crc32[2] = crc32[1] ^ table[index][2];
    crc32[1] = crc32[0] ^ table[index][1];
    crc32[0] =            table[index][0];
}


void nwos_crc32_calculate(uint8 *data, size_t length, uint8 crc32[4])
{
    int i;

    crc32[0] = 0xFF;
    crc32[1] = 0xFF;
    crc32[2] = 0xFF;
    crc32[3] = 0xFF;

    for (i = 0; i < length; i++) {
	crc32_add(data[i], crc32);
    }
}

