/*
--         This file is part of the New World OS and Objectify projects
--                    Copyright (C) 2004-2009  QRW Software
--              J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                         http://www.qrwsoftware.com
--                         http://nwos.sourceforge.com
--                      http://objectify.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: chunk_info.h,v $
-- Revision 1.12  2009/06/23 13:05:46  jsedwards
-- Added MD5_VERIFIED_MASK and external declarations for verified functions.
--
-- Revision 1.11  2009/06/13 16:29:12  jsedwards
-- Moved external declaration for nwos_allocate_new_chunk from gen_id.h to
-- chunk_info.h because it is defined in the chunk_info.c file.
--
-- Revision 1.10  2009/06/01 10:44:02  jsedwards
-- Added Chunk_Info structure from Alpha_29.10_branch and called it
-- Chunk_Info_0029.
--
-- Revision 1.9  2009/05/09 16:04:01  jsedwards
-- Added external declarations for new nwos_blocks_used_in_chunk and
-- nwos_chunk_is_full functions.
--
-- Revision 1.8  2009/04/21 11:47:22  jsedwards
-- Changed chunk_info.ref to 64 bits and chunk_info.index to 32 bits.
--
-- Revision 1.7  2009/04/19 14:49:47  jsedwards
-- Added external declaration for new nwos_clear_chunk_digest function.
--
-- Revision 1.6  2009/04/19 09:01:27  jsedwards
-- Moved external references for nwos_hash_uint32_ref, nwos_hash_ref, and
-- nwos_ref_to_offset from gen_id.h file.
--
-- Revision 1.5  2009/04/13 13:21:16  jsedwards
-- Removed file descriptor parameter from initialize and terminate functions.
--
-- Revision 1.4  2009/04/11 21:41:29  jsedwards
-- Changed so that bit map size is derived from USABLE_BLOCKS_PER_CHUNK.
--
-- Revision 1.3  2009/04/11 21:11:30  jsedwards
-- Moved bit map and chunk defines from the disk_io.h file.
--
-- Revision 1.2  2009/04/07 12:44:39  jsedwards
-- Merged changes from objectify_private.h file in CVS
-- branch_0030_new_chunk_info branch, see revision 1.69.2.1 in disk_io.h file.
--
-- Revision 1.1  2009/03/14 22:43:37  jsedwards
-- Created from declarations moved from the disk_io.h file.
--
*/


#ifndef CHUNK_INFO_H
#define CHUNK_INFO_H

#include "reference.h"


#define USABLE_BLOCKS_PER_CHUNK 65536

#define BIT_MAP_BYTES (USABLE_BLOCKS_PER_CHUNK / 8)
#define BIT_MAP_BLOCKS (BIT_MAP_BYTES / FILE_BLOCK_SIZE)

#define BLOCKS_IN_CHUNK (BIT_MAP_BLOCKS + USABLE_BLOCKS_PER_CHUNK)

#define CHUNK_SIZE (BLOCKS_IN_CHUNK * FILE_BLOCK_SIZE)



typedef struct {
  uint64 ref;                              /* 8  */
  uint32 flags_used;                       /* 12  */
  uint32 index;                            /* 16 */
  uint8  md5_digest[MD5_DIGEST_SIZE];      /* 32 */
} Chunk_Info;
 
typedef struct {
  uint32 ref;                              /* 4 */
  uint16 used;                             /* 6 */
  uint16 index;                            /* 8 */
} Chunk_Info_0029;


#define CHUNK_INFO_USED_MASK           0x0001FFFF
#define CHUNK_INFO_FULL_MASK           0x00010000
#define CHUNK_INFO_MD5_VERIFIED_MASK   0x80000000


extern Chunk_Info* nwos_chunk_info;


extern void nwos_initialize_chunk_info(void);
extern void nwos_terminate_chunk_info(void);
extern void nwos_update_chunk_info_reverse_index();
extern int  nwos_chunk_index_to_info_index(uint16 chunk_index);
extern int  nwos_uint32_ref_to_info_index(uint32 ref);

extern uint32 nwos_hash_uint32_ref(uint32 ref);
extern uint32 nwos_hash_ref(ObjRef* ref);
extern off_t  nwos_ref_to_offset(ObjRef* ref);

extern void nwos_clear_chunk_digest(ObjRef* ref);

extern void nwos_allocate_new_chunk(uint32 ref);

extern uint32 nwos_blocks_used_in_chunk(int info_index);        /* returns the number of blocks used in chunk */
extern bool   nwos_chunk_is_full(int info_index);               /* returns true if chunk is full */

extern bool nwos_chunk_md5_has_been_verified(int info_index);          /* chunk MD5 checksum has been verified */
extern void nwos_set_chunk_md5_verified(int info_index);
extern void nwos_clear_chunk_md5_verified(int info_index);

extern void nwos_increment_chunk_info_block_used(int info_index);
extern void nwos_decrement_chunk_info_block_used(int info_index);
extern void nwos_reset_chunk_info_blocks_used(int info_index, uint32 blocks_used);

#endif

