/*
--             This file is part of the New World OS project
--                 Copyright (C) 2006-2009  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: gen_id.h,v $
-- Revision 1.6  2009/03/19 11:03:39  jsedwards
-- Wrapped nwos_set_security_level and restart_id_generation declarations with
-- ifdef CHANGE_SECURITY_TO_DENSITY to disable security level stuff for now.
--
-- Revision 1.5  2009/03/18 13:27:00  jsedwards
-- Removed external declarations for nwos_generate_new_completely_random_id,
-- nwos_generate_new_closely_spaced_id, and nwos_generate_new_1_in_N_id, they
-- are now static.
--
-- Revision 1.4  2009/03/18 13:10:48  jsedwards
-- Removed external declaration for nwos_set_allocation_parameters because
-- it is only used in the gen_id.c file.
--
-- Revision 1.3  2009/03/14 23:05:08  jsedwards
-- Moved the external declaration for nwos_next_public_ref from the disk_io.h
-- file.
--
-- Revision 1.2  2009/03/14 11:18:30  jsedwards
-- Moved all id generation related declarations from disk_io.h and objectify.h
-- files.
--
-- Revision 1.1  2009/03/13 04:48:47  jsedwards
-- Moved various declarations from objectify.h.
--
*/


#ifndef GEN_ID_H
#define GEN_ID_H

#include "reference.h"


typedef enum { Security_None=0, Security_Minimal, Security_Very_Low, Security_Low, Security_Medium, Security_High, Security_Extreme } Security_Level;

extern ObjRef nwos_next_public_ref;

extern void nwos_initialize_gen_id(void);
extern void nwos_terminate_gen_id(void);

extern uint32 nwos_hash_uint32_ref(uint32 ref);
extern uint32 nwos_hash_ref(ObjRef* ref);
extern off_t  nwos_ref_to_offset(ObjRef* ref);

#ifdef CHANGE_SECURITY_TO_DENSITY
extern void nwos_set_security_level(Security_Level);
extern void nwos_restart_id_generation();
#endif

extern void nwos_generate_new_public_id(ObjRef* ref);
extern void nwos_generate_new_id(ObjRef* ref);
extern void nwos_generate_new_private_id(ObjRef* ref);

extern bool nwos_check_blocks_available(uint32 estimated_blocks);

extern void nwos_allocate_new_chunk(uint32 ref);

#endif

