--
--             This file is part of the New World OS project
--                    Copyright (C) 2008  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: file_path.e,v $
-- Revision 1.1  2008/11/28 17:11:56  jsedwards
-- Initial experimental quick hack.
--
--


class FILE_PATH

inherit OBJECTIFY_OBJECT

creation read_from_disk

feature

   read_from_disk(id: REFERENCE) is
      do
         !!reference.copy(id)
         storage := wrapper_read_file_path(reference.to_external)

--             std_output.put_string("Ref list count: ");
--             std_output.put_integer(references.count);
--             std_output.put_new_line;
      end

   path: STRING is
      do
         if save_path = Void then
            from
               !!save_path.make(wrapper_file_path_count(storage))
            until
               save_path.count = save_path.capacity
            loop
               save_path.extend(wrapper_file_path_item(storage, save_path.count))
            end
         end

         Result := save_path
      end

feature {NONE}

   save_path: STRING

   wrapper_read_file_path(ref: POINTER): POINTER is
      external "C"
      end

   wrapper_file_path_count(obj: POINTER): INTEGER is
      external "C"
      end

   wrapper_file_path_item(obj: POINTER; index: INTEGER): CHARACTER is
      external "C"
      end

end

