--
--             This file is part of the New World OS project
--                 Copyright (C) 2006-2007  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- This program converts a file with a single column of names to multiple
-- strings per line wrapped in quotes and comma separated for C input.
--
-- $Log: names_to_strings.e,v $
-- Revision 1.2  2007/07/01 19:44:12  jsedwards
-- Upgrade to GPLv3.
--
-- Revision 1.1  2006/12/24 12:35:32  jsedwards
-- Program to convert a list of names (one per line) to strings for inclusion
-- in a C program.
--


class NAMES_TO_STRINGS

creation make

feature

   make is
      local
         name: STRING
         line: STRING
      do
         !!name.make(16);
         !!line.make(116);

         from
            std_input.read_line_in(name)
         until
            std_input.end_of_input
         loop
            name.remove_trailing_spaces

            if line.count + name.count + 4 > line.capacity then
               std_output.put_string(line)
               std_output.put_new_line
               line.clear
            end

            line.extend('%"')
            line.append(name)
            line.append("%", ")

            std_input.read_line_in(name)
         end

         
         std_output.put_string(line)
         std_output.put_new_line
      end

end

