--             This file is part of the New World OS project
--                    Copyright (C) 2008  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: add_assert_to_read_object.e,v $
-- Revision 1.1  2008/08/31 16:03:49  jsedwards
-- Initial version of program to wrap all of the calls to
-- nwos_read_object_from_disk and nwos_read_variable_sized_object_from_disk
-- in an assert, because now they return false if they failed whereas before
-- they asserted themselves.
--

class ADD_ASSERT_TO_READ_OBJECT

creation make

feature

   make is
      local
         i: INTEGER
      do
         from
            i := 1
         until
            i > argument_count
         loop
            process_file(argument(i))

            i := i + 1
         end
      end


   process_file(file_name: STRING) is
      local
         line: STRING
         function_name: STRING
         changed: BOOLEAN
         new_file_name: STRING
         state: INTEGER
      do
         std_output.put_string(file_name)
         std_output.put_new_line

         new_file_name := string_pool.item(file_name.count + 1)
         new_file_name.copy(file_name)
         new_file_name.append(".temporary")

         in_file.connect_to(file_name)

	 if in_file.is_connected then
            out_file.connect_to(new_file_name)
         end

	 if in_file.is_connected and out_file.is_connected then
            line := string_pool.item(256)
            function_name := string_pool.item(128)

            from
               in_file.read_line_in(line)
            until
               in_file.end_of_input
            loop
               if line.count > 0 then
                  inspect
                     state
                  when 0 then
                     out_file.put_string(line)

                     if line.item(1).is_letter and then line.occurrences(' ') > 0 and then line.has('(') and then line.last = ')' then
                        if line.has_prefix("static") then
                           line.remove_prefix("static ")
                        end
                        line.remove_first(line.index_of_first(' '))
                        function_name.copy_substring(line, 1, line.index_of_first('(') - 1)
                        state := 1
                     end

                  when 1 then
                     if line.is_equal("{") then
                        state := 2
                     end
                     out_file.put_string(line)

                  when 2 then
                     if line.is_equal("}") then
                        state := 0
                     elseif line.has_substring("nwos_read_object_from_disk(") then
                        std_output.put_string("  ")
                        std_output.put_string(function_name)
                        std_output.put_string(": nwos_read_object_from_disk")
                        std_output.put_new_line

                        line.insert_string("assert(", line.index_of_first('n'))

                        if line.has(';') then
                           line.insert_character(')', line.index_of_first(';'))
                        else
                           state := 3
                        end
                        changed := true;
                     elseif line.has_substring("nwos_read_variable_sized_object_from_disk(") then
                        std_output.put_string("  ")
                        std_output.put_string(function_name)
                        std_output.put_string(": nwos_read_variable_sized_object_from_disk")
                        std_output.put_new_line

                        line.insert_string("assert(", line.index_of_first('n'))

                        if line.has(';') then
                           line.insert_character(')', line.index_of_first(';'))
                        else
                           state := 3
                        end
                        changed := true;
                     end
                     out_file.put_string(line)

                  when 3 then
                     if line.has(';') then
                        line.insert_character(')', line.index_of_first(';'))
                        state := 2
                     end
                     out_file.put_string(line)
                  end
               end

               out_file.put_new_line
               in_file.read_line_in(line)
            end

            in_file.close
            out_file.disconnect

            if not changed then
               remove_file(new_file_name)
            end

            string_pool.put(function_name)
            string_pool.put(line)
         else
            std_output.put_string("** unable to open **%N")
         end

         string_pool.put(new_file_name)
      end

   in_file: TEXT_FILE_READ is
      once
         !!Result.make("hello")
      end

   out_file: TEXT_FILE_WRITE is
      once
         !!Result.make
      end

end


