/*
--             This file is part of the New World OS project
--                 Copyright (C) 2007-2008  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
-- This program is just a quick test of the nwos_normalize_path function.
--
-- $Log: test_normalize_path.c,v $
-- Revision 1.1  2008/06/25 14:32:57  jsedwards
-- Initial version.
--
*/


#include <stdio.h>
#include <string.h>

#include "objectify.h"

struct whatever
{
  char* input;
  char* output;
} test_data[] = {
   { "a",                  "a" },
   { "a/",                 "a" },
   { ".a",                 ".a" },
   { "./a",                "a" },
   { "./a/",               "a" },
   { "a//",                "a" },
   { "a///",               "a" },
   { "a/////////////////", "a" },

   { "ab",                 "ab" },
   { ".ab",                ".ab" },
   { "ab/",                "ab" },
   { ".ab/",               ".ab" },

   { "ab",                 "ab" },
   { ".ab",                ".ab" },
   { "..ab",               "..ab" },
   { "ab/",                "ab" },
   { ".ab/",               ".ab" },
   { "..ab/",              "..ab" },
   { "ab.",                "ab." },
   { "ab./",               "ab." },
   { "ab..",               "ab.." },
   { "ab../",              "ab.." },

   { "abc",                "abc" },
   { "abc//",               "abc" },

   { "abc/def",            "abc/def" },
   { "abc/def////",        "abc/def" },
   { "abc//def/",          "abc/def" },
   { "abc///def/////////", "abc/def" },
   { "abc////////////def", "abc/def" },

   { "abc/def/ghi",        "abc/def/ghi" },
   { "abc//def/ghi",       "abc/def/ghi" },
   { "abc/def//ghi",       "abc/def/ghi" },
   { "abc//def//ghi",      "abc/def/ghi" },
   { "abc///def///ghi",    "abc/def/ghi" },
   { "abc////def////ghi",  "abc/def/ghi" },

   { ".",                  "." },
   { "./",                 "." },
   { "./.",                "." },
   { "././",               "." },
   { ".//.",               "." },
   { ".//./",              "." },
   { ".//.//",             "." },
   { ".///.",              "." },
   { ".///./",             "." },
   { ".///.///",           "." },
   { "././//////////////", "." },
   { ".///////////////./", "." },
   { ".////.////.///././", "." },

   { "..",                 ".." },
   { "../",                ".." },
   { "./..",               ".." },
   { "./../",              ".." },
   { "../.",               ".." },
   { "..//",               ".." },
   { "..//.",              ".." },
   { "..//./",             ".." },
   { "..//.//",            ".." },
   { ".././././",          ".." },
   { "..///",              ".." },
   { "..///.",             ".." },
   { "..///////////////.", ".." },
   { "../////////.////./", ".." },
   { ".././/////////////", ".." },
   { "..////.//.////.///", ".." },
   { "..////.//.//././/.", ".." },

   { "abc/../..",          ".." },
   { "abc/../../",         ".." },
   { "abc/..//..",         ".." },
   { "abc/..//..//",       ".." },
   { "../abc/..",          ".." },
   { "../abc/../",         ".." },
   { "../abc/../..",       "../.." },
   { "../abc/../../",      "../.." },
   { "./abc/..//..",       ".." },
   { "./abc/..//..//",     ".." },
   { "abc/../../.",        ".." },
   { "abc/../.././",       ".." },
   { "abc/..//../.",       ".." },
   { "abc/..//..//./.",    ".." },
   { "abc/..//.//../.",    ".." },
   { "abc/.//..//../.",    ".." },
   { "abc/..//.//..",      ".." },
   { "abc/..//.//../",     ".." },
   { "../abc/../.",        ".." },
   { "../abc/.././",       ".." },
   { "../abc/./../..",     "../.." },
   { ".././abc/../../",    "../.." },
   { "./../abc//..",       ".." },
   { "././../abc/..//",    ".." },

   { "abc/../def/..",      "." },
   { "abc/..//def/../",    "." },
   { "abc//def/../..",     "." },
   { "abc/def/../../",     "." },
   { "abc/../../def",      "../def" },
   { "abc//..//..//def/",  "../def" },
   { "abc/./def/..",       "abc" },
   { "abc/./def/../",      "abc" },
   { "abc/def/../ghi",     "abc/ghi" },
   { "abc/./def/../ghi/",  "abc/ghi" },
   { "abc/./def/..",       "abc" },
   { "abc/./def/../",      "abc" },
   { "abc/../def",         "def" },
   { "abc/../def/",        "def" },
   { "abc/.././def",       "def" },
   { "abc/.././def/",      "def" },

   { "../..",              "../.." },
   { "../../",             "../.." },
   { ".././..",            "../.." },
   { "..//..",             "../.." },
   { "../../.",            "../.." },
   { "..//.//..",          "../.." },
   { "..//.//../",         "../.." },
   { "../././..",          "../.." },
   { "../././../",         "../.." },
   { "..///..",            "../.." },
   { "..///../",           "../.." },
   { "..//////////////..", "../.." },
   { "..//////..//.///./", "../.." },
   { "..////////..//////", "../.." },
   { "..////.//.////..//", "../.." },
   { "..///.//.//././/..", "../.." },
   { "..//.//.//././/../", "../.." },
};

#define NUM_TESTS (sizeof(test_data)/sizeof(struct whatever))

int main()
{
    int i;
    char path[128];
    int result = 0;

    for (i = 0; i < NUM_TESTS; i++)
    {
	printf("%s -> ", test_data[i].input);
	fflush(stdout);

	nwos_normalize_path(path, test_data[i].input, sizeof(path));

	printf("%s", path);
	fflush(stdout);

	if (strcmp(path, test_data[i].output) != 0)
	{
	    printf("   Expected: %s", test_data[i].output);
	    result = 1;
	}

	printf("\n");
    }

    return result;
}


