/*
--         This file is part of the New World OS and Objectify projects
--                    Copyright (C) 2004-2009  QRW Software
--              J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                         http://www.qrwsoftware.com
--                         http://nwos.sourceforge.com
--                      http://objectify.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: chunk_info.h,v $
-- Revision 1.1  2009/03/14 22:43:37  jsedwards
-- Created from declarations moved from the disk_io.h file.
--
*/


#ifndef CHUNK_INFO_H
#define CHUNK_INFO_H

#include "types.h"

typedef struct {
  uint32 ref;
  uint16 used;
  uint16 index;
} Chunk_Info;

extern Chunk_Info* nwos_chunk_info;


extern void nwos_initialize_chunk_info(int private_file_desc);
extern void nwos_terminate_chunk_info(int private_file_desc);
extern void nwos_update_chunk_info_reverse_index();
extern int  nwos_chunk_index_to_info_index(uint16 chunk_index);
extern int  nwos_uint32_ref_to_info_index(uint32 ref);
extern void nwos_increment_chunk_info_block_used(int info_index);
extern void nwos_decrement_chunk_info_block_used(int info_index);
extern void nwos_reset_chunk_info_blocks_used(int info_index, uint32 blocks_used);

#endif

