/*
--             This file is part of the New World OS project
--                 Copyright (C) 2006-2007  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: attribute.c,v $
-- Revision 1.7  2007/07/01 19:44:11  jsedwards
-- Upgrade to GPLv3.
--
-- Revision 1.6  2006/05/01 12:49:09  jsedwards
-- If inherit value is "void" don't output it.  This should only ever happen
-- on the base class itself.
--
-- Revision 1.5  2006/04/12 11:14:06  jsedwards
-- Change attributes parameter to create_definition to an array of pointers
-- to references.
--
-- Revision 1.4  2006/04/11 13:06:24  jsedwards
-- Added "implementation" and "inherit" to "create definition".
--
-- Revision 1.3  2006/04/09 14:43:37  jsedwards
-- Added "create_definition" routine, which probably shouldn't be in this
-- file or this file should be renamed.  But since this stuff is all
-- temporary anyway, I'm just going to stick it here for now.
--
-- Revision 1.2  2006/04/09 03:31:00  jsedwards
-- Added "const" to all "reference" parameters and changed "plurality" to
-- "multiplicity".
--
-- Revision 1.1  2006/04/08 14:02:38  jsedwards
-- Routine to create an attribute.
--
*/

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "predefined_references.h"

char* attribute_revision = "$Revision: 1.7 $";


/*---------------------------------------------------------------------------------------------------------
  attribute definition:

    definition attribute:     attribute
    creation attribute:       log
    name attribute:           name list   -- optional, only present if name is different than type
    plurality attribute:      single or multiple
    presence attribute:       required or optional
    mutability/modifiability attribute: fixed/frozen or addable/changeable
    type attribute:           definition of type
---------------------------------------------------------------------------------------------------------*/

void create_attribute(const reference id, const reference log, const reference presence, 
		      const reference multiplicity, const reference mutability, const reference type)
{
    char path[NWOS_PATH_MAX];
    FILE* fp;

    nwos_ref_to_path(id, path);

    fp = fopen(path, "wb");

    if (fp == NULL)
    {
	perror(path);
	exit(1);
    }

    write_file_header(id, fp);

    write_pair(Ref_attr_definition,   Ref_def_attribute, fp);
    write_pair(Ref_attr_creation,     log, fp);
    write_pair(Ref_attr_presence,     presence, fp);
    write_pair(Ref_attr_multiplicity, multiplicity, fp);
    write_pair(Ref_attr_mutability,   mutability, fp);
    write_pair(Ref_attr_type,         type, fp);

    if (fclose(fp) != 0)
    {
	perror(path);
	exit(1);
    }
}


/*---------------------------------------------------------------------------------------------------------
  definition definition:

    definition attribute:     definition (points to itself)
    creation attribute:       log
    name attribute:           attribute
    attribute attribute:      attribute definition
---------------------------------------------------------------------------------------------------------*/

void create_definition(const reference id, const reference log, const reference description, 
		       const reference implemenation, const reference inherit, const reference* attributes[])
{
    char path[NWOS_PATH_MAX];
    FILE* fp;
    int i;

    nwos_ref_to_path(id, path);

    fp = fopen(path, "wb");

    if (fp == NULL)
    {
	perror(path);
	exit(1);
    }

    write_file_header(id, fp);

    write_pair(Ref_attr_definition,    Ref_def_definition, fp);
    write_pair(Ref_attr_creation,      log, fp);
    write_pair(Ref_attr_description,   description, fp);

    write_pair(Ref_attr_implementation, implemenation, fp);
    if (memcmp(inherit, Ref_void, sizeof(reference)) != 0)
    {
	write_pair(Ref_attr_inherit, inherit, fp);
    }

    for (i = 0; attributes[i] != NULL; i++)
    {
	write_pair(Ref_attr_attribute, *attributes[i], fp);
    }

    if (fclose(fp) != 0)
    {
	perror(path);
	exit(1);
    }
}


