/*
--             This file is part of the New World OS project
--                   Copyright (C) 2007  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- This is a one time use program to add a bunch of features to the PERSON class
--
-- $Log: add_to_check.c,v $
-- Revision 1.3  2007/07/01 19:44:12  jsedwards
-- Upgrade to GPLv3.
--
-- Revision 1.2  2007/04/11 14:25:41  jsedwards
-- Added "order", "image" and "carbon image".
--
-- Revision 1.1  2007/04/11 12:07:42  jsedwards
-- Initial version created from add_to_person.c.
--
*/


#include <assert.h>
#include <ctype.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "../crc32.h"
#include "../objectify_private.h"


#if 0
static size_t get_spelling_object_size(void* spelling_obj)
{
    assert(((C_struct_Spelling*)spelling_obj)->count > 0);
    return sizeof(C_struct_Spelling) + ((C_struct_Spelling*)spelling_obj)->count;
}

static size_t get_name_object_size(void* name_obj)
{
    assert(((C_struct_Name*)name_obj)->count > 0);
    return sizeof(C_struct_Name) + (((C_struct_Name*)name_obj)->count * sizeof(ObjRef));
}
#endif

static size_t get_class_object_size(void* class_obj)
{
    return sizeof(C_struct_Class_Definition) + (((C_struct_Class_Definition*)class_obj)->count * sizeof(ObjRef));
}

void add_feature(C_struct_Class_Definition* class_obj_ptr, ObjRef* type, char* name)
{
    int count;
    ObjRef feature_ref;

    assert(get_class_object_size(class_obj_ptr) < FILE_BLOCK_SIZE);

    count = class_obj_ptr->count;

    nwos_find_or_create_public_feature_definition(type, name, 1, &feature_ref);

    copy_reference(&class_obj_ptr->feature[count], &feature_ref);

    nwos_add_to_references(&class_obj_ptr->header.common.id, &feature_ref);

    class_obj_ptr->count = count + 1;

    printf("feature: %d - %s  new size: %d\n", count, name, (int)get_class_object_size(class_obj_ptr));
}



int main(int argc, char* argv[])
{
    ObjRef root_ref;
    ObjRef check_class_ref;
    ObjRef objref_class_ref;
    uint8 kludge[FILE_BLOCK_SIZE];
    C_struct_Class_Definition* check_class_obj_ptr = (C_struct_Class_Definition*)kludge;

    nwos_log_arguments(argc, argv);

    nwos_initialize_objectify(NULL, 0, 0, DEFAULT_TYPE_RW, DEFAULT_FILE);

    nwos_set_encryption_level(Encryption_None);

    printf("Updating check class on: %s\n", DEFAULT_FILE);

    printf("next_reference: %02x%02x%02x%02x\n", 
	   nwos_next_public_ref.id[0],
	   nwos_next_public_ref.id[1],
	   nwos_next_public_ref.id[2],
	   nwos_next_public_ref.id[3]);

    root_ref.id[0] = 0;
    root_ref.id[1] = 0;
    root_ref.id[2] = 0;
    root_ref.id[3] = 1;

    nwos_set_root_object(&root_ref);

    if (!nwos_find_public_class_definition("CHECK", &check_class_ref))
    {
	fprintf(stderr, "Could not locate CHECK class definition\n");
	nwos_terminate_objectify();
	exit(1);
    }

    printf("check_class_ref: %02x%02x%02x%02x\n",
	   check_class_ref.id[0],
	   check_class_ref.id[1],
	   check_class_ref.id[2],
	   check_class_ref.id[3]);

    if (!nwos_find_public_class_definition("OBJECT REFERENCE", &objref_class_ref))
    {
	fprintf(stderr, "Could not locate OBJECT REFERENCE class definition\n");
	nwos_terminate_objectify();
	exit(1);
    }

    printf("objref_class_ref: %02x%02x%02x%02x\n",
	   objref_class_ref.id[0],
	   objref_class_ref.id[1],
	   objref_class_ref.id[2],
	   objref_class_ref.id[3]);

    nwos_read_variable_sized_object_from_disk(&check_class_ref, kludge, sizeof(kludge), &get_class_object_size);

    printf("  number of features: %d\n", check_class_obj_ptr->count);

    if (check_class_obj_ptr->count != 8)
    {
	fprintf(stderr, "CHECK class has already been changed, has more than 8 features!\n");
	nwos_terminate_objectify();
	exit(1);
    }

    add_feature(check_class_obj_ptr, &objref_class_ref, "written amount");
    add_feature(check_class_obj_ptr, &objref_class_ref, "order");
    add_feature(check_class_obj_ptr, &objref_class_ref, "image");
    add_feature(check_class_obj_ptr, &objref_class_ref, "carbon image");


    nwos_crc32_calculate((uint8*) &check_class_obj_ptr->header.object,
			 sizeof(ObjectHeader),
			 check_class_obj_ptr->header.common.header_chksum);

    nwos_crc32_calculate((uint8*) &check_class_obj_ptr->name,
			 get_class_object_size(check_class_obj_ptr) - sizeof(EveryObject),
			 check_class_obj_ptr->header.common.data_chksum);

    nwos_overwrite_object_to_disk(&check_class_ref, check_class_obj_ptr, get_class_object_size(check_class_obj_ptr));


    nwos_terminate_objectify();

    return 0;
}

