--
--             This file is part of the New World OS project
--                 Copyright (C) 2006-2007  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: generate_c_code.e,v $
-- Revision 1.2  2007/07/01 19:44:13  jsedwards
-- Upgrade to GPLv3.
--
-- Revision 1.1  2007/06/03 12:40:54  jsedwards
-- Moved from root directory.
--
-- Revision 1.5  2006/05/01 12:52:14  jsedwards
-- Changed to deal with inheritance from another class.  Re-arranged features
-- to allow calling recursively.
--
-- Revision 1.4  2006/04/22 14:10:14  jsedwards
-- Changed generate_attributes to fill in structure.  Doesn't do inherited
-- attributes yet.
--
-- Revision 1.3  2006/04/16 13:52:21  jsedwards
-- Added routine (incomplete) to fill in the attributes.
--
-- Revision 1.2  2006/04/15 17:02:13  jsedwards
-- Changed to use a "reference" object instead of "ref_path" to convert the
-- reference to a path.
--
-- Revision 1.1  2006/04/15 13:57:37  jsedwards
-- Initial version, incomplete.
--

-- This program converts a definition into .h and .c files.

class GENERATE_C_CODE

creation make

feature

   make is
      local
         i: INTEGER
      do
         from
            i := 1
         until
            i > argument_count
         loop
            conv_file(argument(i))
            i := i + 1
         end
      end

   conv_file(path: STRING) is
      local
         time: STRING
      do
         !!time.make(28)

         std_output.put_string(path)
         std_output.put_character(' ')

         in_file.make(path)
         in_file.set_big_endian
         in_file.open

         if in_file.is_open then
            if header_ok(in_file, path, time) then
               generate_h_file(path, time)
            end

            in_file.close
         else
            std_output.put_string(" - unable to open.")
         end

         std_output.put_new_line
      end


   header_ok(stream: BINARY_INPUT_STREAM; path, time: STRING): BOOLEAN is
      local
         four: STRING
         time_stamp: NWOS_TIME_STAMP
         ref: REFERENCE
      do
         !!four.make(4)
         !!time_stamp.make
         !!ref.make

         read(stream, four)
         if not four.is_equal("NWOS") then
            std_output.put_string(" - missing magic number: NWOS.")
         else
            read(stream, four)
            if not four.is_equal("0011") then
               std_output.put_string(" - wrong version: ")
               std_output.put_string(four)
               std_output.put_string(", must be 0011.")
            else
               time_stamp.read_from_stream(stream)
               time_stamp.append_in(time)
               std_output.put_string(time)

               ref.read_from_binary_stream(stream)
-- std_output.put_string(ref.to_hexadecimal)
               if not path.is_equal(ref.path) then
                  std_output.put_string(" - path doesn't match: ")
                  std_output.put_string(ref.path)
               else
                  Result := True
               end
            end
         end
      end

   read(stream: BINARY_INPUT_STREAM; ref: STRING) is
      require
         not stream.end_of_input
      do
         from
            ref.clear
         until
            stream.end_of_input or else ref.count = ref.capacity
         loop
            stream.read_byte
            ref.extend(stream.last_byte)
         end
      ensure
         ref.count = ref.capacity
      end


   generate_h_file(path, time: STRING) is
      local
         name: STRING
         h_filename: STRING
      do
         name := string_pool.item(path.count)
         !!name.copy(path)
         name.remove_prefix("/obj/nwos/definitions/")
         name.remove_suffix(".obj")

         h_filename := string_pool.item(name.count + 2)
         h_filename.copy(name)
         h_filename.append(".h")

         out_file.connect_to(h_filename)

         if out_file.is_connected then
            out_file.put_string("/* This file was created by generate_c_code from */%N/* ")
            out_file.put_string(path)
            out_file.put_string(" */%N")

            out_file.put_string("/* Timestamp: ")
            out_file.put_string(time)
            out_file.put_string(" */%N%N")

            name.to_upper
            out_file.put_string("#ifndef ")
            out_file.put_string(name)
            out_file.put_string("_H%N")

            out_file.put_string("#define ")
            out_file.put_string(name)
            out_file.put_string("_H%N%N")
            name.to_lower

            out_file.put_string("#include %"reference.h%"%N%N")

            out_file.put_string("typedef struct {%N")
            generate_attributes(in_file)
            out_file.put_string("} struct_")
            out_file.put_string(name)
            out_file.put_string(";%N%N")

            out_file.put_string("#endif%N%N")
            out_file.disconnect
         else
            std_output.put_string(" - unable to open output file: ")
            std_output.put_string(h_filename)
         end

         string_pool.put(name)
         string_pool.put(h_filename)
      end

   call_depth: INTEGER

   generate_attributes(stream: BINARY_INPUT_STREAM) is
      local
         att: REFERENCE
         val: REFERENCE
         attribute: STRING
         value: STRING
      do
         !!att.make
         !!val.make
         !!attribute.make(32)
         !!value.make(32)

         call_depth := call_depth + 1
         check
            call_depth < 3
         end

         from
            att.read_from_binary_stream(stream)
         until
            stream.end_of_input
         loop
            val.read_from_binary_stream(stream)

            if not att.path.has_prefix("/obj/nwos/attributes/") then
               std_error.put_string("%N%Nnot an attribute: ")
               std_error.put_string(att.path)
            else
std_output.put_string("%Ngenerate_attributes ")
std_output.put_string(att.path)
std_output.put_string(" - ")
std_output.put_string(val.path)
std_output.put_new_line
               if att.path.has_prefix("/obj/nwos/attributes/inherit_") then
std_output.put_string("FOUND inherit%N")
                  value.copy(val.path)
                  value.remove_prefix("/obj/nwos/definitions/")
                  value.remove_suffix("_0000.obj")

                  std_output.put_string("(inherit ")
                  std_output.put_string(value)
                  inherit_from_file(val.path)
                  std_output.put_string(")")
std_output.flush
               elseif att.path.has_prefix("/obj/nwos/attributes/attribute_") then
                  value.copy(val.path)
                  value.remove_prefix("/obj/nwos/attributes/")
                  value.remove_suffix("_0000.obj")

                  out_file.put_string("    reference ")
                  out_file.put_string(value)
                  out_file.put_string(";%N")
               end
            end

            att.read_from_binary_stream(stream)
         end
      end
         
   inherit_from_file(path: STRING) is
      local
         inherit_file: BINARY_FILE_READ
         time: STRING
      do
         !!inherit_file.make(path)
         time := string_pool.item(28)

         inherit_file.set_big_endian
         inherit_file.open

         if inherit_file.is_open then
            if header_ok(inherit_file, path, time) then
               generate_attributes(inherit_file)
            end

            inherit_file.close
         else
            std_output.put_string(" - unable to open.")
         end

         string_pool.put(time)
      end


   in_file: BINARY_FILE_READ is
      once
         !!Result.make(Void)
      end


   out_file: TEXT_FILE_WRITE is
      once
         !!Result.make
      end

end

