--
--             This file is part of the New World OS project
--                 Copyright (C) 2006-2007  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: reference.e,v $
-- Revision 1.2  2007/07/01 19:44:14  jsedwards
-- Upgrade to GPLv3.
--
-- Revision 1.1  2007/06/03 12:40:58  jsedwards
-- Moved from root directory.
--
-- Revision 1.2  2006/04/16 13:53:21  jsedwards
-- Fixed the reading of bytes so the end of file is handled correctly.
--
-- Revision 1.1  2006/04/15 17:05:54  jsedwards
-- Moved functionality of "ref_path" class into the "reference" class.
--

-- class to deal with the version 0011 references

class REFERENCE

creation make

feature

   make is
      do
         storage := storage.calloc(16)
      end

   path: STRING is
      do
         if path_string = Void then
            !!path_string.make_empty
            path_storage := path_storage.calloc(128)
         end

         if storage.all_default(15) then  -- void refernce
            path_storage.clear_all(127)
         else
            nwos_ref_to_path(storage.to_external, path_storage.to_pointer)
            path_string.from_external(path_storage.to_pointer)  -- this just points it to "storage" and sets the count.
         end

         Result := path_string
      ensure
         not storage.all_default(15) implies not Result.is_empty
      end

   read_from_binary_stream(stream: BINARY_INPUT_STREAM) is
      local
         i: INTEGER
      do
-- std_output.put_string("read_from_binary_stream: ")
         from
            i := 0
            stream.read_byte
         until
            stream.end_of_input or i = 16
         loop
            storage.put(stream.last_byte, i)
--std_output.put_string(stream.last_byte.to_hexadecimal)
            i := i + 1
            if i < 16 then
               stream.read_byte
            end
         end
--std_output.put_new_line

         if i = 0 then
            storage.clear_all(15)
         elseif i < 16 then
            std_error.put_string("Unexpected end of file%N")
            die_with_code(exit_failure_code)
         end
      end

   to_hexadecimal: STRING is
      do
         !!Result.make(36)
         storage.item(0).to_hexadecimal_in(Result)
         storage.item(1).to_hexadecimal_in(Result)
         storage.item(2).to_hexadecimal_in(Result)
         storage.item(3).to_hexadecimal_in(Result)
         Result.extend(' ')
         storage.item(4).to_hexadecimal_in(Result)
         storage.item(5).to_hexadecimal_in(Result)
         storage.item(6).to_hexadecimal_in(Result)
         storage.item(7).to_hexadecimal_in(Result)
         Result.extend(' ')
         storage.item(8).to_hexadecimal_in(Result)
         storage.item(9).to_hexadecimal_in(Result)
         storage.item(10).to_hexadecimal_in(Result)
         storage.item(11).to_hexadecimal_in(Result)
         Result.extend(' ')
         storage.item(12).to_hexadecimal_in(Result)
         storage.item(13).to_hexadecimal_in(Result)
         storage.item(14).to_hexadecimal_in(Result)
         storage.item(15).to_hexadecimal_in(Result)
      end


feature {NONE}

   storage: NATIVE_ARRAY[CHARACTER];

   path_string: STRING

   path_storage: NATIVE_ARRAY[CHARACTER];

   nwos_ref_to_path(ref, native_string: POINTER) is
      external "C"
      end
end

