--
--             This file is part of the New World OS project
--                 Copyright (C) 2006-2007  QRW Software
--           J. Scott Edwards - j.scott.sedwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: class_definition.e,v $
-- Revision 1.16  2007/07/01 19:44:12  jsedwards
-- Upgrade to GPLv3.
--
-- Revision 1.15  2006/11/02 13:50:57  jsedwards
-- Added "make_from_csv" feature to create object from cvs line.
--
-- Revision 1.14  2006/10/31 23:24:38  jsedwards
-- Add code to add reference to objects that these objects reference.
--
-- Revision 1.13  2006/10/31 23:11:43  jsedwards
-- Change to use class_def_class_def global once feature to access reference
-- list instead of find_class.
--
-- Revision 1.12  2006/10/31 14:19:37  jsedwards
-- Added add_references feature to reference_list.
--
-- Revision 1.11  2006/10/31 14:17:48  jsedwards
-- Added code to add all class definitions to the reference list.
--
-- Revision 1.10  2006/10/31 14:07:00  jsedwards
-- Added reference_lists.
--
-- Revision 1.9  2006/10/30 13:37:32  jsedwards
-- Change to only create a new name if there isn't one already in all_names.
--
-- Revision 1.8  2006/10/30 13:09:35  jsedwards
-- Change to add a class to all_classes when it is created.
--
-- Revision 1.7  2006/10/30 12:23:51  jsedwards
-- Changed "name" feature to a "name" object instead of a string.
--
-- Revision 1.6  2006/10/29 14:37:51  jsedwards
-- Force class name to lower case.
--
-- Revision 1.5  2006/10/28 15:08:06  jsedwards
-- Added reference.
--
-- Revision 1.4  2006/10/28 14:57:29  jsedwards
-- Added GPL header (oops!).
--


class CLASS_DEFINITION

inherit GLOBALS
        REFERENCE_COUNTER

creation make, make_from_csv

feature

   reference: UNSIGNED

   reference_list: REFERENCE_LIST

   name: NAME

   features: FIXED_ARRAY[FEATURE_DEFINITION]

   make is
      do
         !!features.with_capacity(8)

         reference := next_reference

         !!reference_list.make

         all_classes.add_last(Current)
      end

   put_name(class_name: STRING) is
      require
         name = Void
      do
         name := find_name(class_name)

         if name = Void then
            !!name.make(class_name)
         end

         name.reference_list.add_reference(reference)

         class_def_class_def.reference_list.add_reference(reference)
      end

   add_feature(feat_def: FEATURE_DEFINITION) is
      do
         features.add_last(feat_def)

         feat_def.reference_list.add_reference(reference)
      end


   make_from_csv(line: STRING) is
      local
         dummy: UNSIGNED
      do
         !!features.with_capacity(4)

         reference := scan_reference(line)

         check_comma(line)

         skip_time(line)

         check_comma(line)

         dummy := scan_reference(line)   -- ignore class for now

         check_comma(line)

         dummy := scan_reference(line)   -- ignore refernce list for now

         check_comma(line)

         dummy := scan_reference(line)   -- read name reference

         name := find_name_from_reference(dummy)

         from
         until
            line.is_empty
         loop
            check_comma(line)

            dummy := scan_reference(line)  -- read feature reference

            features.add_last(find_feature_from_reference(dummy))
         end
      end

end

