--             This file is part of the New World OS project
--                   Copyright (C) 2006  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file COPYING.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: nwos_reference.e,v $
-- Revision 1.1  2007/04/14 02:24:17  jsedwards
-- Move Fine (Eiffel) files to next_gen directory.
--
-- Revision 1.26  2006/11/11 12:29:19  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.25  2006/03/02 04:10:58  jsedwards
-- Incomplete version, does not work!  Started changing for variable length
-- references.
--
-- Revision 1.24  2006/02/20 14:22:46  jsedwards
-- Added "make_binary_code" feature which is sort of cheating the system and
-- generating the binary code reference directly.
--
-- Revision 1.23  2006/02/20 05:36:34  jsedwards
-- Added "proper noun" class.
--
-- Revision 1.22  2006/02/19 19:07:06  jsedwards
-- Wrapped debug print statement when object read in, in "debug" so they only
-- print when debug is passed to compiler.
--
-- Revision 1.21  2006/02/19 15:55:18  jsedwards
-- Changed the name of NWOS_HEADER to NWOS_OBJECT.
--
-- Revision 1.20  2006/02/17 14:08:00  jsedwards
-- Added "character", "procurement", "punctuation_mark", and "source_file"
-- classes.
--
-- Revision 1.19  2006/02/12 01:48:36  jsedwards
-- Wrapped print statements with 'debug'.
--
-- Revision 1.18  2006/02/11 18:48:17  jsedwards
-- Took out the debugging print statements and the loops that checked to make
-- sure things hadn't changed unexpectedly.
--
-- Revision 1.17  2006/02/11 15:25:57  jsedwards
-- Changed "load" feature to "get_object" which no longer automatically loads
-- every object.  This eliminates the recursion and loading of unnecessary
-- objects.
--
-- Revision 1.16  2006/02/11 04:54:32  jsedwards
-- Rearranged so it doesn't call itself recursively for class definition
-- objects.  Added a ton of debugging print statements and check but it
-- still doesn't work correctly.
--
-- Revision 1.15  2006/02/10 20:23:52  jsedwards
-- Added "require" clause to "load" so that it cannot be called on the void
-- reference (all 0's).
--
-- Revision 1.14  2006/02/10 14:50:29  jsedwards
-- Added code to "load" feature to make sure the class definition for the
-- object is loaded before loading the object.
--
-- Revision 1.13  2006/02/10 14:23:40  jsedwards
-- Changed so that reference.load creates an unresolved object first, and puts
-- it into the cache before loading it.  This means if reference.load is
-- called again recursively, the object is already in the cache and can be
-- returned without trying to create a new (duplicate) object and it doesn't
-- get stuck in an infinite recursive loop.
--
-- Revision 1.12  2006/02/10 05:04:11  jsedwards
-- Added "to string" routine.
--
-- Revision 1.11  2006/02/09 05:46:08  jsedwards
-- Fixed "exists" routine and added features to allow new objects to be
-- added and retrieved from the cache.
--
-- Revision 1.10  2006/02/08 19:27:48  jsedwards
-- Added make_from_string routine so it can be created when it is read in.
--
-- Revision 1.9  2006/02/08 14:10:18  jsedwards
-- Added object cache and inherit from predefined references.
--
-- Revision 1.8  2006/02/08 04:42:37  jsedwards
-- Added routine to load an object.
--
-- Revision 1.7  2006/02/06 19:51:27  jsedwards
-- Started adding a feature to find or load an object.  Incomplete - won't
-- compile.
--
-- Revision 1.6  2006/01/29 18:13:27  jsedwards
-- Added redefintions of "copy" and "is equal" functions so that when a
-- reference is copied it is a complete copy and the storage native array
-- isn't shared.  Also added some access functions to access the storage.
--
-- Revision 1.5  2006/01/29 00:27:56  jsedwards
-- Fixed indexing bug in read and write routines (native array is 0 based).
-- Added "is void" feature and added .obj extention to path names so that
-- they are identified as being unsigned.
--
-- Revision 1.4  2006/01/27 14:17:46  jsedwards
-- Fixed bug in conversion to path, added out_in_tagged_out_memory and
-- increment routines.
--
-- Revision 1.3  2006/01/27 04:23:02  jsedwards
-- Added code for "make" routine.
--
-- Revision 1.2  2006/01/25 13:39:20  jsedwards
-- Added "path_size" feature to tell how long a path string is.
--
-- Revision 1.1  2006/01/24 14:06:30  jsedwards
-- Fine (Eiffel) class to represent an object reference (16 bytes).
--
--

-- It might be better to have this be an extended class, but I'm not sure how
-- that works, having an expanded class (NATIVE_ARRAY) inside of an expanded
-- class.

class NWOS_REFERENCE

inherit NWOS_PREDEFINED_REFERENCES
        HASHABLE
        GENERAL
           redefine
              copy,
              is_equal,
              out_in_tagged_out_memory
           end


creation make, copy, make_from_stream, make_binary_code

feature

   path(str: STRING) is
      local
         first_two_bytes: INTEGER
      do
         str.copy("/objectify/")

         first_two_bytes := (storage.item(0).to_integer * 256) + storage.item(1).to_integer

         inspect 
            first_two_bytes
         when 0 then
            str.append("computer/os/nwos/")
            inspect
               storage.item(2)
            when 0U then
               str.append("binary_codes/")
               storage.item(3).append_in_hexadecimal(str)
            else
               std_error.put_string("Unknown reference computer/os/nwos: ")
               std_error.put_string(to_string)
               std_error.put_new_line
               die_with_code(exit_failure_code)
            end

         when 4096 then
            str.append("language/latin/latin/")
         when 4097 then
            str.append("language/latin/english/")
         when 4098 then
            str.append("language/latin/letters/")
         when 4099 then
            str.append("language/latin/spelling/")
         else
            std_error.put_string("Unknown reference: ")
            std_error.put_string(to_string)
            std_error.put_new_line
            die_with_code(exit_failure_code)
         end

         str.append(".obj")  -- until we can add the signature ourselves add this as an identifier it's not signed
      end

   path_size: INTEGER is
      local
         temp: STRING
      once
         temp := string_pool.item(64)
         path(temp)
         Result := temp.count
         string_pool.put(temp)
      end

   exists: BOOLEAN is
      -- true if the object already exists on disk
      local
         tmp_str: STRING
      do
         tmp_str := string_pool.item(path_size)
         path(tmp_str)
         file.make(tmp_str)
         Result := file.exists
         string_pool.put(tmp_str)
      end        

feature -- read objects in

   -- WARNING!! the reference CANNOT change, therefore DON'T use any references that are "once"!!!

   get_object(class_ref: NWOS_REFERENCE): NWOS_OBJECT is
         -- get the object associated with this reference or create an empty one if it doesn't already exist
      require
         not is_void
      local
         temp_ref: like Current
--temp_str: STRING
--i: INTEGER
      do
debug
std_output.put_string("NWOS_REFERENCE.get_object(")
std_output.put_string(to_string)
std_output.put_string(")%N")
end
         if cache.has(Current) then   -- already in cache
debug
std_output.put_string("found in cache%N")
end
            Result := cache.at(Current)
         else
            !!temp_ref.copy(Current)    -- make a copy since Current could have a different value later
debug
std_output.put_string("not found in cache%N")
            from
               i := cache.lower
            until
               i > cache.upper
            loop
               check
                  not cache.key(i).is_equal(Current)
                  cache.item(i).identifier.is_equal(cache.key(i))
               end

               i := i + 1
            end
end

            -- make an unresolved object first so we can put it in the cache

            if (class_ref.is_equal(Class_class_definition_ref)) then
               !NWOS_CLASS_DEFINITION!Result.make_unresolved(Current)
            elseif (class_ref.is_equal(Class_alphabet_ref)) then
               !NWOS_ALPHABET!Result.make_unresolved(Current)
            elseif (class_ref.is_equal(Class_application_ref)) then
               !NWOS_APPLICATION!Result.make_unresolved(Current)
            elseif (class_ref.is_equal(Class_ascii_character_ref)) then
               !NWOS_ASCII_CHARACTER!Result.make_unresolved(Current)
            elseif (class_ref.is_equal(Class_binary_code_ref)) then
               !NWOS_BINARY_CODE!Result.make_unresolved(Current)
            elseif (class_ref.is_equal(Class_character_ref)) then
               !NWOS_CHARACTER!Result.make_unresolved(Current)
            elseif (class_ref.is_equal(Class_consonant_ref)) then
               !NWOS_CONSONANT!Result.make_unresolved(Current)
            elseif (class_ref.is_equal(Class_language_ref)) then
               !NWOS_LANGUAGE!Result.make_unresolved(Current)
            elseif (class_ref.is_equal(Class_lower_case_ref)) then
               !NWOS_LOWER_CASE_CHARACTER!Result.make_unresolved(Current)
            elseif (class_ref.is_equal(Class_noun_ref)) then
               !NWOS_NOUN!Result.make_unresolved(Current)
            elseif (class_ref.is_equal(Class_object_grade_ref)) then
               !NWOS_OBJECT_GRADE!Result.make_unresolved(Current)
            elseif (class_ref.is_equal(Class_procurement_ref)) then
               !NWOS_PROCUREMENT!Result.make_unresolved(Current)
            elseif (class_ref.is_equal(Class_proper_noun_ref)) then
               !NWOS_PROPER_NOUN!Result.make_unresolved(Current)
            elseif (class_ref.is_equal(Class_punctuation_mark_ref)) then
               !NWOS_PUNCTUATION_MARK!Result.make_unresolved(Current)
            elseif (class_ref.is_equal(Class_root_ref)) then
               !NWOS_ROOT!Result.make_unresolved(Current)
            elseif (class_ref.is_equal(Class_session_log_ref)) then
               !NWOS_SESSION_LOG!Result.make_unresolved(Current)
            elseif (class_ref.is_equal(Class_sometimes_vowel_ref)) then
               !NWOS_SOMETIMES_VOWEL!Result.make_unresolved(Current)
            elseif (class_ref.is_equal(Class_source_file_ref)) then
               !NWOS_SOURCE_FILE!Result.make_unresolved(Current)
            elseif (class_ref.is_equal(Class_spelling_ref)) then
               !NWOS_SPELLING!Result.make_unresolved(Current)
            elseif (class_ref.is_equal(Class_spelling_index_ref)) then
               !NWOS_SPELLING_INDEX!Result.make_unresolved(Current)
            elseif (class_ref.is_equal(Class_upper_case_ref)) then
               !NWOS_UPPER_CASE_CHARACTER!Result.make_unresolved(Current)
            elseif (class_ref.is_equal(Class_user_ref)) then
               !NWOS_USER!Result.make_unresolved(Current)
            elseif (class_ref.is_equal(Class_vowel_ref)) then
               !NWOS_VOWEL!Result.make_unresolved(Current)
            else
               crash
            end
debug
            std_output.put_string("ref: ")
            std_output.put_string(to_string)
            temp_str := string_pool.item(128)
            std_output.put_string("  object: ")
            Result.to_pointer.append_in(temp_str)
            std_output.put_string(temp_str)
            std_output.put_new_line
            string_pool.put(temp_str)
end
            -- put it in the cache so that if this is called again for the same object we already have it
            cache.put(Result, temp_ref)
--            cache.put(Result, Current)
         end
debug
         std_output.put_string("returning: ")
         std_output.put_string(to_string)
         temp_str := string_pool.item(128)
         std_output.put_string("  object: ")
         Result.to_pointer.append_in(temp_str)
         std_output.put_string(temp_str)
         string_pool.put(temp_str)
         std_output.put_string(" id: ")
         std_output.put_string(Result.identifier.to_string)
         std_output.put_new_line
end
      ensure
         Result.identifier.is_equal(Current)
--         Result.class_definition.identifier.is_equal(class_ref)
      end

   object: NWOS_OBJECT is
      do
         if cache.has(Current) then
            Result := cache.at(Current)
         end
      end

   has_object: BOOLEAN is
      do
         Result := cache.has(Current)
      end

   put(obj: NWOS_OBJECT) is
       -- put a new item with this reference
      require
         not has_object   -- make sure this reference is not already in cache
      do
         cache.put(obj, Current)
      ensure
         cache.has(Current)
         cache.at(Current) = obj
      end


feature

   hash_code: INTEGER is
      local
         i: INTEGER
         bits: BIT 32
      do
         from
            i := 1
         until
            i > count
         loop
           -- rotate bits 8 bits left and exclusive or in new bits
           bits := (bits #<< 8) xor storage.item(i).code.to_bit
           i := i + 1
         end

         Result := bits.to_integer

debug
std_output.put_string("hash code:")
std_output.put_string(to_string)
std_output.put_string(" -> ")
std_output.put_integer(Result)
std_output.put_new_line
end
      end

   is_void: BOOLEAN is
      do
         Result := storage.all_default(count)
      end

   read_from_stream(stream: BINARY_INPUT_STREAM) is
      local
         i: INTEGER
      do
         from
            i := 0
         until
            i = count
         loop
           stream.read_byte
           storage.put(stream.last_byte, i)
           i := i + 1
         end
      end

   write_to_stream(stream: BINARY_OUTPUT_STREAM) is
      local
         i: INTEGER
      do
         from
            i := 0
         until
            i = count
         loop
           stream.put_character(storage.item(i))
           i := i + 1
         end
      end

   increment is
      -- not sure if this is a good thing but it will do for now
      local
         i: INTEGER
         new: INTEGER
      do
         from
            i := count
            new := 256    -- carry in
         until
            new /= 256 or else count = 0
         loop
            i := i - 1
            check
               i >= 0
            end
            new := storage.item(i).code + 1
            storage.put(new.to_character, i)
         end
      end

feature  -- access

   count: INTEGER is 16

   lower: INTEGER is 0

   upper: INTEGER is
      do
         Result := count - 1
      end

   item(index: INTEGER): CHARACTER is
      require
         lower <= index and index <= upper
      do
         Result := storage.item(index)
      end

   last: CHARACTER is
      do
         Result := item(upper)
      end

feature  -- printing

   out_in_tagged_out_memory is
         -- Append terse printable represention of current object
         -- in `tagged_out_memory'.
      local
         i: INTEGER
      do
         tagged_out_memory.append(generating_type);
         if not is_expanded_type then
            tagged_out_memory.extend('#');
            Current.to_pointer.append_in(tagged_out_memory);
         end;
         tagged_out_memory.extend('[');
         tagged_out_memory.extend(' ');

         from
            i := 0
         until
            i = count
         loop
            storage.item(i).to_hexadecimal_in(tagged_out_memory)

            if (i \\ 4) = 3 then  -- add path separator
               tagged_out_memory.extend(' ')
            end
            i := i + 1
         end
         tagged_out_memory.extend(']');
      end;
   

   to_string: STRING is
      local
         i: INTEGER
      do
         !!Result.make(36)

         from
            i := 0
         until
            i = count
         loop
            storage.item(i).to_hexadecimal_in(Result)

            if (i \\ 4) = 3 then  -- add path separator
               Result.extend(' ')
            end
            i := i + 1
         end
      end


   copy(other: like Current) is
      do
         storage := storage.calloc(count)
         storage.copy_from(other.storage, count)
      end

   is_equal(other: like Current): BOOLEAN is
         -- Is `other' attached to an object considered equal to 
         -- current object ?
      do
         Result := storage.fast_memcmp(other.storage, count)
      end


feature {NWOS_REFERENCE}

   storage: NATIVE_ARRAY[CHARACTER]


feature {NONE}

   make(quad1, quad2, quad3, quad4: UNSIGNED) is
      do
         storage := storage.calloc(count);

         storage.put((quad1.to_bit @>> 24).to_character, 0)
         storage.put((quad1.to_bit @>> 16).to_character, 1)
         storage.put((quad1.to_bit @>>  8).to_character, 2)
         storage.put( quad1               .to_character, 3)

         storage.put((quad2.to_bit @>> 24).to_character, 4)
         storage.put((quad2.to_bit @>> 16).to_character, 5)
         storage.put((quad2.to_bit @>>  8).to_character, 6)
         storage.put( quad2               .to_character, 7)

         storage.put((quad3.to_bit @>> 24).to_character, 8)
         storage.put((quad3.to_bit @>> 16).to_character, 9)
         storage.put((quad3.to_bit @>>  8).to_character, 10)
         storage.put( quad3               .to_character, 11)

         storage.put((quad4.to_bit @>> 24).to_character, 12)
         storage.put((quad4.to_bit @>> 16).to_character, 13)
         storage.put((quad4.to_bit @>>  8).to_character, 14)
         storage.put( quad4               .to_character, 15)
      end

   make_from_stream(stream: BINARY_INPUT_STREAM) is
      do
         storage := storage.calloc(count);
         read_from_stream(stream)
      end

   make_binary_code(code: CHARACTER) is
         -- sort of cheating, make a reference to the binary code
      do
         make(Computer_domain, Nwos_domain, 0x00000000, 0x00000100 + code.code.to_unsigned)
      end

   cache: DICTIONARY[NWOS_OBJECT, NWOS_REFERENCE] is
      once
         !!Result.with_capacity(4111)
      end

   file: BINARY_FILE_READ is
      once
         !!Result.make(Void)
      end

end

