/*             This file is part of the New World OS project
--                Copyright (C) 2005, 2006  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file LICENSE.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- This program is a run once, never again.  It creates the 256 binary code
-- objects (0x200-0x2FF) and the 256 reference lists (0x300-0x3FF) for them.
-- No one should ever have to run this program again, since those objects
-- now exist.
--
-- $Log: create_binary_codes.c,v $
-- Revision 1.1  2007/06/03 12:28:19  jsedwards
-- Moved from root directory.
--
-- Revision 1.5  2006/11/11 12:01:02  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.4  2006/04/08 14:01:04  jsedwards
-- Complete overhaul to build the new format (0011) binary codes.
--
-- Revision 1.3  2006/01/22 16:58:07  jsedwards
-- Fixed so only lower 128 binary codes reference the ascii character set.
--
-- Revision 1.2  2006/01/22 15:12:59  jsedwards
-- Changed for new binary codes object (that has the reference list inlined).
--
-- Revision 1.1  2006/01/18 13:22:13  jsedwards
-- Run once app to create the binary code objects and their reference lists.
--
*/

#include <assert.h>
#include <stdio.h>
#include <string.h>   /* define memset */
#include <stdlib.h>

#include "predefined_references.h"

char* create_binary_codes_revision = "$Revision: 1.1 $";


static void gen_one_byte_code_ref(uint8 code, reference ref)
{
    int i;
    for (i = 0; i < sizeof(reference); i++) ref[i] = 0;
    ref[0] = DOMAIN_BINARY_CODES + 1;
    ref[1] = code;
}


/*---------------------------------------------------------------------------------------------------------------------------
  instance of binary code:

    definition attribute:     binary code
    creation attribute:       log
    number of bits attribute: cardinal 8
    binary_bits attribute:    xx
    reference attribute:      list of references - pointer to a list of instances for various types (character codes, etc.)
---------------------------------------------------------------------------------------------------------------------------*/

int main()
{
    reference binary_code_ref;
    reference binary_bits;
    char path[NWOS_PATH_MAX];
    int i;
    FILE* fp;

    printf("Creating 256 binary code objects...\n");

    memset(binary_bits, 0, sizeof(reference));

    for (i = 0; i < 256; i++)
    {
	gen_one_byte_code_ref(i, binary_code_ref);   /* create the reference */

	nwos_ref_to_path(binary_code_ref, path);

	fp = fopen(path, "wb");

	if (fp == NULL)
	{
	    perror(path);
	    exit(1);
	}

	write_file_header(binary_code_ref, fp);

	write_pair(Ref_attr_definition,  Ref_def_binary_code, fp);

	write_pair(Ref_attr_creation,    Ref_create_eight_bit_binary_codes, fp);

	write_pair(Ref_attr_num_of_bits, Ref_cardinal_8, fp);

	binary_bits[0] = i;
	write_pair(Ref_attr_binary_bits, binary_bits, fp);

	/* Let's go with having the character codes stored within this object instead of a separate list for now */
	/*	write_pair(Ref_attr_char_code_list, Ref_char_code_list??, fp); */

	if (fclose(fp) != 0)
	{
	    perror(path);
	    exit(1);
	}
    }

    printf("Done!\n");

    return 0;
}

