--             This file is part of the New World OS project
--                   Copyright (C) 2006  QRW Software
--           J. Scott Edwards - j.scott.sedwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file COPYING.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: csv_merge.e,v $
-- Revision 1.2  2006/12/18 20:59:27  jsedwards
-- Added code to finish copying the file if the tail of the file is identical.
--
-- Revision 1.1  2006/12/11 12:38:40  jsedwards
-- Initial version.
--
--
-- Program to merge the changes in a csv file into a new file.  This is a
-- complicated procedure as follows:
--
--   mkdir old_csv
--   mv -i *.csv old_csv
--   ./convert_c_structs_to_csv
--   mkdir new_csv
--   mv -i *.csv new_csv
--   cd old_csv
--   for file in *.csv; do ../remove_time < $file > $file.wot; done
--   cd ../new_csv
--   for file in *.csv; do ../remove_time < $file > $file.wot; done
--   cd ..
--   diff -u ???_csv/reference_list.csv.wot > reference_list.dif
--   ./csv_merge ???_csv/reference_list.csv reference_list.dif > reference_list.csv
--  
--     merge other files as necessary
--
--   for file in *.csv; do ./remove_time < $file > $file.wot; done
--   diff reference_list.csv.wot new_csv/
--

class CSV_MERGE

creation make

feature

   make is
      local
         old_file: STD_FILE_READ
         new_file: STD_FILE_READ
         dif_file: STD_FILE_READ

         old_line: STRING
         new_line: STRING
         dif_line: STRING
         prefx: STRING
         suffx: STRING
      do
         !!old_file.connect_to(argument(1))
         !!new_file.connect_to(argument(2))
         !!dif_file.connect_to(argument(3))

         !!old_line.make(4096)
         !!new_line.make(4096)
         !!dif_line.make(4096)

         !!prefx.make(12)
         !!suffx.make(4096)

         from
            dif_file.read_line_in(dif_line)
         until
            dif_file.end_of_input
         loop
            inspect
               dif_line.first
            when '@' then
               -- ignore it for simplicity?
            when ' ' then
               prefx.copy_substring(dif_line, 2, 13)
               suffx.copy_substring(dif_line, 14, dif_line.upper)
               find_line_output(prefx, old_file, old_line)
               find_line(prefx, new_file, new_line)
               check
                  old_line.has_suffix(suffx)
                  new_line.has_suffix(suffx)
               end
               std_output.put_string(old_line)
               std_output.put_new_line
            when '-' then
               prefx.copy_substring(dif_line, 2, 13)
               suffx.copy_substring(dif_line, 14, dif_line.upper)
               find_line_output(prefx, old_file, old_line)
               check
                  old_line.has_suffix(suffx)
               end
            when '+' then
               prefx.copy_substring(dif_line, 2, 13)
               suffx.copy_substring(dif_line, 14, dif_line.upper)
               find_line(prefx, new_file, new_line)
               check
                  new_line.has_suffix(suffx)
               end
               std_output.put_string(new_line)
               std_output.put_new_line
            end

            dif_file.read_line_in(dif_line)
         end

         from
            old_line.clear
            old_file.read_line_in(old_line)
         until
            old_file.end_of_input
         loop
            std_output.put_string(old_line)
            std_output.put_new_line
            old_line.clear
            old_file.read_line_in(old_line)
         end

         old_file.disconnect
         new_file.disconnect
         dif_file.disconnect
      end

   find_line(prefx: STRING; stream: INPUT_STREAM; line: STRING) is
      do
         from
            line.clear
            stream.read_line_in(line)
         until
            line.has_prefix(prefx)
         loop
            line.clear
            stream.read_line_in(line)
         end
      end

   find_line_output(prefx: STRING; stream: INPUT_STREAM; line: STRING) is
      do
         from
            line.clear
            stream.read_line_in(line)
         until
            line.has_prefix(prefx)
         loop
            std_output.put_string(line)
            std_output.put_new_line
            line.clear
            stream.read_line_in(line)
         end
      end

end

