/*             This file is part of the New World OS project
--                Copyright (C) 2005, 2006  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package; see the file LICENSE.   If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: address.c,v $
-- Revision 1.13  2007/01/06 20:10:41  jsedwards
-- Change to find_public_spelling instead of find_spelling.
--
-- Revision 1.12  2006/12/21 12:59:47  jsedwards
-- Hack to make it compile with new split public and private classes,
-- NON-FUNCTIONAL!
--
-- Revision 1.11  2006/12/07 14:08:46  jsedwards
-- Moved setup routine and associated functions to attic/big_bang.c.
--
-- Revision 1.10  2006/12/01 14:31:30  jsedwards
-- Changed to use new malloc_reference_list and free_reference_list functions
-- instead of inlining the code.
--
-- Revision 1.9  2006/11/11 12:01:01  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.8  2006/10/26 01:51:22  jsedwards
-- Merged alpha_05_branch back into main trunk.
--
-- Revision 1.7.2.2  2006/10/25 12:22:26  jsedwards
-- Changed C_struct_class_definition to C_struct_Class_Definition so the case
-- is consistent with all the other C_struct objects.
--
-- Revision 1.7.2.1  2006/09/01 13:27:20  jsedwards
-- Changed "nwos_object_size" to "nwos_reference_list_size" and added the
-- object reference to "nwos_fill_in_common_header" so it can put the "id"
-- in the header now.
--
-- Revision 1.7  2006/01/06 14:10:34  jsedwards
-- Added "direction" class stuff, setup routine and (commented out) add
-- address routine.
--
-- Revision 1.6  2005/12/29 17:50:53  jsedwards
-- Commented out printf debugging statements, that aren't useful now.
--
-- Revision 1.5  2005/12/29 17:01:41  jsedwards
-- Changed to just read spelling obj header to get reference list instead of
-- the whole variable sized object.
--
-- Revision 1.4  2005/12/27 18:20:07  jsedwards
-- Changed to look up class definition instead of fixed file name.
--
-- Revision 1.3  2005/12/24 16:18:26  jsedwards
-- Removed "host" id from object references (ObjRef).  Host redirection will
-- be done using a "redirection" object in the future.
--
-- Revision 1.2  2005/12/21 03:44:33  jsedwards
-- Changed so "postal_code" is not a separate class, but just part of the
-- "state" object.  Removed the "create_postal_code" routine.
--
-- Revision 1.1  2005/12/17 15:21:37  jsedwards
-- Initial version with separate object for postal code.
--
*/


#include <assert.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>   /* define memset */

#include "crc32.h"
#include "objectify.h"
#include "objectify_private.h"


bool nwos_find_state_postal_code(char* state_postal_code, ObjRef* ref)
{
    EveryObject spelling_header;
    ObjRef state_class_ref;
    ObjRef spelling_ref;
    ObjRef object_class;
    ReferenceList* ref_list;
    int num_spellings;
    int i;
    bool result = false;

    assert(strlen(state_postal_code) == 2);

    assert(nwos_find_public_class_definition("US STATE", &state_class_ref));

    if (nwos_find_public_spelling(state_postal_code, &spelling_ref))
    {
	nwos_read_object_headers_from_disk(&spelling_ref, &spelling_header);

	ref_list = nwos_malloc_reference_list(&spelling_header.object.references);

	num_spellings = ref_list->common_header.num_refs;

	/* printf("num_spellings (in find_state_postal_code): %d\n", num_spellings); */

	for (i = 0; i < num_spellings; i++)
	{
	    nwos_get_object_class(&ref_list->references[i], &object_class);   /* find out what kind of object it is */

	    if (is_same_object(&object_class, &state_class_ref))   /* it is a state_postal_code object */
	    {
		memcpy(ref, &ref_list->references[i], sizeof(ObjRef));
		result = true;
		break;
	    }
	}

	nwos_free_reference_list(ref_list);
	ref_list = NULL;
    }

    return result;
}

#if 0
static void get_input(char* descr, char* buffer, size_t size)
{
    char *ptr;

    while (1)
    {
	printf("%s: ", descr);
	fflush(stdout);
	fgets(buffer, size, stdin);
	ptr = strchr(buffer, '\n');
	if (ptr != NULL)
	{
	    *ptr = '\0';
	    break;
	}
	do { fgets(buffer, size, stdin); } while (strchr(buffer, '\n') == NULL);
	printf("input too long - try again!\n");
    }
}



nwos_add_address(&address_ref)
{
    ObjRef reference;
    char street[80];
    ObjRef address_class_ref;
    ObjRef city_ref;
    char* error_msg;


    nwos_find_private_class_definition("ADDRESS", &addres_class_ref);

    ok = false;
    while (!ok)
    {
	get_input("street", street, sizeof(street));
	ok = nwos_is_valid_street_address(street, error_msg);
	if (!ok) 
	{
	    printf("%s\n", error_msg);
	    printf("Please re-enter.\n");
	}
    }

    nwos_add_city(&city_ref);

    memset(&address_obj, 0, sizeof(address_obj));

	nwos_generate_new_id(&reference);

	nwos_fill_in_common_header(&address_obj.header.common, &reference, &address_class_ref);

	nwos_create_name(first_name, &address_obj.first_name);
	nwos_add_to_references(&reference, &address_obj.first_name);

	nwos_create_reference_list(&reference, &address_obj.header.object.references);

	nwos_crc32_calculate((uint8*) &address_obj.header.object, sizeof(ObjectHeader), address_obj.header.common.header_chksum);

	nwos_crc32_calculate((uint8*) &address_obj.gender, sizeof(address_obj) - sizeof(EveryObject), address_obj.header.common.data_chksum);

	nwos_write_object_to_disk(&reference, &address_obj, sizeof(address_obj));

        nwos_add_to_references(&reference, &address_class_ref);
	
	printf("Address created: %08lx\n", nwos_ref_to_word(&reference));
    }
}

#endif

